/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.bitmap;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.fileindex.bitmap.BitmapFileIndexMeta;
import org.apache.paimon.fileindex.bitmap.BitmapTypeVisitor;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;
import org.apache.paimon.types.DataType;

public class BitmapFileIndexMetaV2
extends BitmapFileIndexMeta {
    private long blockSizeLimit;
    private List<BitmapIndexBlock> indexBlocks;
    private long indexBlockStart;
    private int nullBitmapLength;

    public BitmapFileIndexMetaV2(DataType dataType, Options options) {
        super(dataType, options);
        this.nullBitmapLength = -1;
    }

    public BitmapFileIndexMetaV2(DataType dataType, Options options, int rowCount, int nonNullBitmapNumber, boolean hasNullValue, int nullValueOffset, int nullBitmapLength, LinkedHashMap<Object, Integer> bitmapOffsets, int finalOffset) {
        super(dataType, options, rowCount, nonNullBitmapNumber, hasNullValue, nullValueOffset, bitmapOffsets);
        this.nullBitmapLength = nullBitmapLength;
        this.blockSizeLimit = MemorySize.parse(options.getString("index-block-size", "16kb")).getBytes();
        this.bitmapLengths = new HashMap();
        Object lastValue = null;
        int lastOffset = nullValueOffset;
        for (Map.Entry<Object, Integer> entry : bitmapOffsets.entrySet()) {
            Object value = entry.getKey();
            Integer offset = entry.getValue();
            if (offset < 0) continue;
            if (lastOffset >= 0) {
                this.bitmapLengths.put(lastValue, offset - lastOffset);
            }
            lastValue = value;
            lastOffset = offset;
        }
        this.bitmapLengths.put(lastValue, finalOffset - lastOffset);
    }

    public static Comparator<Object> getComparator(DataType dataType) {
        return dataType.accept(new BitmapTypeVisitor<Comparator<Object>>(){

            @Override
            public Comparator<Object> visitBinaryString() {
                return Comparator.comparing(o -> (BinaryString)o);
            }

            @Override
            public Comparator<Object> visitByte() {
                return Comparator.comparing(o -> (Byte)o);
            }

            @Override
            public Comparator<Object> visitShort() {
                return Comparator.comparing(o -> (Short)o);
            }

            @Override
            public Comparator<Object> visitInt() {
                return Comparator.comparing(o -> (Integer)o);
            }

            @Override
            public Comparator<Object> visitLong() {
                return Comparator.comparing(o -> (Long)o);
            }

            @Override
            public Comparator<Object> visitFloat() {
                return Comparator.comparing(o -> (Float)o);
            }

            @Override
            public Comparator<Object> visitDouble() {
                return Comparator.comparing(o -> (Double)o);
            }

            @Override
            public Comparator<Object> visitBoolean() {
                return Comparator.comparing(o -> (Boolean)o);
            }
        });
    }

    @Override
    public BitmapFileIndexMeta.Entry findEntry(Object bitmapId) {
        if (bitmapId == null) {
            if (this.hasNullValue) {
                return new BitmapFileIndexMeta.Entry(null, this.nullValueOffset, this.nullBitmapLength);
            }
        } else {
            BitmapIndexBlock block = this.findBlock(bitmapId);
            if (block != null) {
                return block.findEntry(bitmapId);
            }
        }
        return null;
    }

    private BitmapIndexBlock findBlock(Object bitmapId) {
        Comparator<Object> comparator = BitmapFileIndexMetaV2.getComparator(this.dataType);
        int idx = Collections.binarySearch(this.indexBlocks, null, (b1, ignore) -> comparator.compare(b1.key, bitmapId));
        idx = idx < 0 ? -2 - idx : idx;
        return idx < 0 ? null : this.indexBlocks.get(idx);
    }

    @Override
    public void serialize(DataOutput out) throws Exception {
        BitmapFileIndexMeta.ThrowableConsumer valueWriter = this.getValueWriter(out);
        out.writeInt(this.rowCount);
        out.writeInt(this.nonNullBitmapNumber);
        out.writeBoolean(this.hasNullValue);
        if (this.hasNullValue) {
            out.writeInt(this.nullValueOffset);
            out.writeInt(this.nullBitmapLength);
        }
        LinkedList<BitmapIndexBlock> indexBlocks = new LinkedList<BitmapIndexBlock>();
        this.indexBlocks = indexBlocks;
        indexBlocks.add(new BitmapIndexBlock(0));
        Comparator<Object> comparator = BitmapFileIndexMetaV2.getComparator(this.dataType);
        this.bitmapOffsets.entrySet().stream().map(it -> new BitmapFileIndexMeta.Entry(it.getKey(), (Integer)it.getValue(), this.bitmapLengths == null ? -1 : this.bitmapLengths.getOrDefault(it.getKey(), -1))).sorted((e1, e2) -> comparator.compare(e1.key, e2.key)).forEach(e -> {
            BitmapIndexBlock last = (BitmapIndexBlock)indexBlocks.peekLast();
            if (!last.tryAdd((BitmapFileIndexMeta.Entry)e)) {
                BitmapIndexBlock next = new BitmapIndexBlock(last.offset + last.serializedBytes);
                indexBlocks.add(next);
                if (!next.tryAdd((BitmapFileIndexMeta.Entry)e)) {
                    throw new RuntimeException("index fail");
                }
            }
        });
        out.writeInt(indexBlocks.size());
        int bitmapBodyOffset = 0;
        for (BitmapIndexBlock e3 : indexBlocks) {
            valueWriter.accept(e3.key);
            out.writeInt(e3.offset);
            bitmapBodyOffset += e3.serializedBytes;
        }
        out.writeInt(bitmapBodyOffset);
        for (BitmapIndexBlock indexBlock : indexBlocks) {
            out.writeInt(indexBlock.entryList.size());
            for (BitmapFileIndexMeta.Entry e4 : indexBlock.entryList) {
                valueWriter.accept(e4.key);
                out.writeInt(e4.offset);
                out.writeInt(e4.length);
            }
        }
    }

    @Override
    public void deserialize(SeekableInputStream seekableInputStream) throws Exception {
        this.indexBlockStart = seekableInputStream.getPos();
        BufferedInputStream inputStream2 = new BufferedInputStream(seekableInputStream);
        DataInputStream in = new DataInputStream(inputStream2);
        BitmapFileIndexMeta.ThrowableSupplier valueReader = this.getValueReader(in);
        Function<Object, Integer> measure = this.getSerializeSizeMeasure();
        this.rowCount = in.readInt();
        this.indexBlockStart += 4L;
        this.nonNullBitmapNumber = in.readInt();
        this.indexBlockStart += 4L;
        this.hasNullValue = in.readBoolean();
        ++this.indexBlockStart;
        if (this.hasNullValue) {
            this.nullValueOffset = in.readInt();
            this.nullBitmapLength = in.readInt();
            this.indexBlockStart += 8L;
        }
        this.bitmapOffsets = new LinkedHashMap();
        int bitmapBlockNumber = in.readInt();
        this.indexBlockStart += 4L;
        this.indexBlocks = new ArrayList<BitmapIndexBlock>(bitmapBlockNumber);
        for (int i = 0; i < bitmapBlockNumber; ++i) {
            Object key = valueReader.get();
            int offset = in.readInt();
            this.indexBlocks.add(new BitmapIndexBlock(this.dataType, this.options, key, offset, seekableInputStream));
            this.indexBlockStart += (long)(measure.apply(key) + 4);
        }
        int bitmapBodyOffset = in.readInt();
        this.indexBlockStart += 4L;
        this.bodyStart = this.indexBlockStart + (long)bitmapBodyOffset;
    }

    class BitmapIndexBlock {
        Object key;
        int offset;
        int serializedBytes = 4;
        List<BitmapFileIndexMeta.Entry> entryList;
        Function<Object, Integer> keyBytesMapper;
        DataType dataType;
        SeekableInputStream seekableInputStream;
        Options options;

        void tryDeserialize() {
            if (this.entryList == null) {
                try {
                    this.seekableInputStream.seek(BitmapFileIndexMetaV2.this.indexBlockStart + (long)this.offset);
                    BufferedInputStream inputStream2 = new BufferedInputStream(this.seekableInputStream);
                    DataInputStream in = new DataInputStream(inputStream2);
                    BitmapFileIndexMeta.ThrowableSupplier valueReader = BitmapFileIndexMetaV2.this.getValueReader(in);
                    int entryNum = in.readInt();
                    this.entryList = new ArrayList<BitmapFileIndexMeta.Entry>(entryNum);
                    for (int i = 0; i < entryNum; ++i) {
                        this.entryList.add(new BitmapFileIndexMeta.Entry(valueReader.get(), in.readInt(), in.readInt()));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        BitmapFileIndexMeta.Entry findEntry(Object bitmapId) {
            this.tryDeserialize();
            Comparator<Object> comparator = BitmapFileIndexMetaV2.getComparator(this.dataType);
            int idx = Collections.binarySearch(this.entryList, null, (e1, ignore) -> comparator.compare(e1.key, bitmapId));
            if (idx >= 0) {
                return this.entryList.get(idx);
            }
            return null;
        }

        boolean tryAdd(BitmapFileIndexMeta.Entry entry) {
            int entryBytes;
            if (this.key == null) {
                this.key = entry.key;
            }
            if ((long)(this.serializedBytes + (entryBytes = 8 + this.keyBytesMapper.apply(entry.key))) > BitmapFileIndexMetaV2.this.blockSizeLimit) {
                return false;
            }
            this.serializedBytes += entryBytes;
            this.entryList.add(entry);
            return true;
        }

        public BitmapIndexBlock(int offset) {
            this.offset = offset;
            this.entryList = new LinkedList<BitmapFileIndexMeta.Entry>();
            this.keyBytesMapper = BitmapFileIndexMetaV2.this.getSerializeSizeMeasure();
        }

        public BitmapIndexBlock(DataType dataType, Options options, Object key, int offset, SeekableInputStream seekableInputStream) {
            this.dataType = dataType;
            this.options = options;
            this.key = key;
            this.offset = offset;
            this.seekableInputStream = seekableInputStream;
        }
    }
}

