/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.operation.DefaultValueAssigner;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataTableBatchScan;
import org.apache.paimon.table.source.DataTableStreamScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.StreamDataTableScan;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.SimpleFileReader;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class ReadOptimizedTable
implements DataTable,
ReadonlyTable {
    public static final String READ_OPTIMIZED = "ro";
    private final FileStoreTable wrapped;

    public ReadOptimizedTable(FileStoreTable wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public OptionalLong latestSnapshotId() {
        return this.wrapped.latestSnapshotId();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.wrapped.snapshot(snapshotId);
    }

    @Override
    public SimpleFileReader<ManifestFileMeta> manifestListReader() {
        return this.wrapped.manifestListReader();
    }

    @Override
    public SimpleFileReader<ManifestEntry> manifestFileReader() {
        return this.wrapped.manifestFileReader();
    }

    @Override
    public SimpleFileReader<IndexManifestEntry> indexManifestFileReader() {
        return this.wrapped.indexManifestFileReader();
    }

    @Override
    public String name() {
        return this.wrapped.name() + "$" + READ_OPTIMIZED;
    }

    @Override
    public RowType rowType() {
        return this.wrapped.rowType();
    }

    @Override
    public List<String> partitionKeys() {
        return this.wrapped.partitionKeys();
    }

    @Override
    public Map<String, String> options() {
        return this.wrapped.options();
    }

    @Override
    public List<String> primaryKeys() {
        return this.wrapped.primaryKeys();
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        if (this.wrapped.schema().primaryKeys().size() > 0) {
            return this.wrapped.newSnapshotReader().withLevelFilter(level -> level == this.coreOptions().numLevels() - 1).enableValueFilter();
        }
        return this.wrapped.newSnapshotReader();
    }

    @Override
    public DataTableBatchScan newScan() {
        return new DataTableBatchScan(this.wrapped.schema().primaryKeys().size() > 0, this.coreOptions(), this.newSnapshotReader(), DefaultValueAssigner.create(this.wrapped.schema()));
    }

    @Override
    public StreamDataTableScan newStreamScan() {
        if (this.wrapped.schema().primaryKeys().size() > 0) {
            throw new UnsupportedOperationException("Unsupported streaming scan for read optimized table");
        }
        return new DataTableStreamScan(this.coreOptions(), this.newSnapshotReader(), this.snapshotManager(), this.wrapped.supportStreamingReadOverwrite(), DefaultValueAssigner.create(this.wrapped.schema()));
    }

    @Override
    public CoreOptions coreOptions() {
        return this.wrapped.coreOptions();
    }

    @Override
    public Path location() {
        return this.wrapped.location();
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.wrapped.snapshotManager();
    }

    @Override
    public SchemaManager schemaManager() {
        return this.wrapped.schemaManager();
    }

    @Override
    public TagManager tagManager() {
        return this.wrapped.tagManager();
    }

    @Override
    public BranchManager branchManager() {
        return this.wrapped.branchManager();
    }

    @Override
    public DataTable switchToBranch(String branchName) {
        return new ReadOptimizedTable(this.wrapped.switchToBranch(branchName));
    }

    @Override
    public InnerTableRead newRead() {
        return this.wrapped.newRead();
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new ReadOptimizedTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions));
    }

    @Override
    public FileIO fileIO() {
        return this.wrapped.fileIO();
    }
}

