/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.ReadPlanStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFromWatermarkStartingScanner
extends ReadPlanStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(StaticFromWatermarkStartingScanner.class);
    private final long watermark;

    public StaticFromWatermarkStartingScanner(SnapshotManager snapshotManager, long watermark) {
        super(snapshotManager);
        this.watermark = watermark;
        Snapshot snapshot = StaticFromWatermarkStartingScanner.timeTravelToWatermark(snapshotManager, watermark);
        if (snapshot != null) {
            this.startingSnapshotId = snapshot.id();
        }
    }

    @Override
    public ScanMode startingScanMode() {
        return ScanMode.ALL;
    }

    @Override
    public SnapshotReader configure(SnapshotReader snapshotReader) {
        if (this.startingSnapshotId == null) {
            LOG.warn("There is currently no snapshot later than or equal to watermark[{}]", (Object)this.watermark);
            throw new RuntimeException(String.format("There is currently no snapshot later than or equal to watermark[%d]", this.watermark));
        }
        return snapshotReader.withMode(ScanMode.ALL).withSnapshot(this.startingSnapshotId);
    }

    @Nullable
    public static Snapshot timeTravelToWatermark(SnapshotManager snapshotManager, long watermark) {
        return snapshotManager.laterOrEqualWatermark(watermark);
    }
}

