/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.memory;

import java.util.List;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentPool;

public class CachelessSegmentPool
implements MemorySegmentPool {
    private final int maxPages;
    private final int pageSize;
    private int numPage;

    public CachelessSegmentPool(long maxMemory, int pageSize) {
        this.maxPages = (int)(maxMemory / (long)pageSize);
        this.pageSize = pageSize;
        this.numPage = 0;
    }

    @Override
    public MemorySegment nextSegment() {
        if (this.numPage < this.maxPages) {
            ++this.numPage;
            return MemorySegment.allocateHeapMemory(this.pageSize);
        }
        return null;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public void returnAll(List<MemorySegment> memory) {
        this.numPage -= memory.size();
    }

    @Override
    public int freePages() {
        return this.maxPages - this.numPage;
    }
}

