/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.sql.Date;
import java.time.LocalDate;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.paimon.hive.objectinspector.WriteableObjectInspector;
import org.apache.paimon.utils.DateTimeUtils;

public class PaimonDateObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements DateObjectInspector,
WriteableObjectInspector {
    public PaimonDateObjectInspector() {
        super(TypeInfoFactory.dateTypeInfo);
    }

    public Date getPrimitiveJavaObject(Object o) {
        return o == null ? null : DateTimeUtils.toSQLDate((Integer)o);
    }

    public DateWritable getPrimitiveWritableObject(Object o) {
        Date date = this.getPrimitiveJavaObject(o);
        return date == null ? null : new DateWritable(date);
    }

    public Object copyObject(Object o) {
        if (o instanceof Date) {
            Date date = (Date)o;
            return new Date(date.getTime());
        }
        return o;
    }

    @Override
    public Integer convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return DateTimeUtils.toInternal((Date)value);
        }
        if (value instanceof DateWritable) {
            return ((DateWritable)value).getDays();
        }
        return DateTimeUtils.toInternal((LocalDate)value);
    }
}

