/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.paimon.catalog.Identifier;
import org.apache.thrift.TException;

public class HiveAlterTableUtils {
    public static void alterTable(IMetaStoreClient client, Identifier identifier, Table table) throws TException {
        try {
            HiveAlterTableUtils.alterTableWithEnv(client, identifier, table);
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            HiveAlterTableUtils.alterTableWithoutEnv(client, identifier, table);
        }
    }

    private static void alterTableWithEnv(IMetaStoreClient client, Identifier identifier, Table table) throws TException {
        EnvironmentContext environmentContext = new EnvironmentContext();
        environmentContext.putToProperties("CASCADE", "true");
        environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "false");
        client.alter_table_with_environmentContext(identifier.getDatabaseName(), identifier.getTableName(), table, environmentContext);
    }

    private static void alterTableWithoutEnv(IMetaStoreClient client, Identifier identifier, Table table) throws TException {
        client.alter_table(identifier.getDatabaseName(), identifier.getTableName(), table, true);
    }
}

