/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypeVisitor;

@Public
public final class VarCharType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final int MIN_LENGTH = 1;
    public static final int MAX_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_LENGTH = 1;
    public static final VarCharType STRING_TYPE = new VarCharType(Integer.MAX_VALUE);
    private static final String FORMAT = "VARCHAR(%d)";
    private static final String MAX_FORMAT = "STRING";
    private final int length;

    public VarCharType(boolean isNullable, int length) {
        super(isNullable, DataTypeRoot.VARCHAR);
        if (length < 1) {
            throw new IllegalArgumentException(String.format("Variable character string length must be between %d and %d (both inclusive).", 1, Integer.MAX_VALUE));
        }
        this.length = length;
    }

    public VarCharType(int length) {
        this(true, length);
    }

    public VarCharType() {
        this(1);
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new VarCharType(isNullable, this.length);
    }

    @Override
    public String asSQLString() {
        if (this.length == Integer.MAX_VALUE) {
            return this.withNullability(MAX_FORMAT, new Object[0]);
        }
        return this.withNullability(FORMAT, this.length);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VarCharType that = (VarCharType)o;
        return this.length == that.length;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.length);
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public static VarCharType stringType(boolean isNullable) {
        return new VarCharType(isNullable, Integer.MAX_VALUE);
    }
}

