/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullStartingScanner
extends AbstractStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(FullStartingScanner.class);

    public FullStartingScanner(SnapshotManager snapshotManager) {
        super(snapshotManager);
        this.startingSnapshotId = snapshotManager.latestSnapshotId();
    }

    @Override
    public ScanMode startingScanMode() {
        return ScanMode.ALL;
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader snapshotReader) {
        Long startingSnapshotId = this.snapshotManager.latestSnapshotId();
        if (startingSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Waiting for snapshot generation.");
            return new StartingScanner.NoSnapshot();
        }
        return StartingScanner.fromPlan(snapshotReader.withMode(ScanMode.ALL).withSnapshot(startingSnapshotId).read());
    }
}

