/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.IntervalPartition;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.utils.BinPacking;

public class MergeTreeSplitGenerator
implements SplitGenerator {
    private final Comparator<InternalRow> keyComparator;
    private final long targetSplitSize;
    private final long openFileCost;
    private final boolean deletionVectorsEnabled;
    private final CoreOptions.MergeEngine mergeEngine;

    public MergeTreeSplitGenerator(Comparator<InternalRow> keyComparator, long targetSplitSize, long openFileCost, boolean deletionVectorsEnabled, CoreOptions.MergeEngine mergeEngine) {
        this.keyComparator = keyComparator;
        this.targetSplitSize = targetSplitSize;
        this.openFileCost = openFileCost;
        this.deletionVectorsEnabled = deletionVectorsEnabled;
        this.mergeEngine = mergeEngine;
    }

    @Override
    public List<SplitGenerator.SplitGroup> splitForBatch(List<DataFileMeta> files) {
        boolean oneLevel;
        boolean rawConvertible = files.stream().allMatch(file -> file.level() != 0 && this.withoutDeleteRow((DataFileMeta)file));
        boolean bl = oneLevel = files.stream().map(DataFileMeta::level).collect(Collectors.toSet()).size() == 1;
        if (rawConvertible && (this.deletionVectorsEnabled || this.mergeEngine == CoreOptions.MergeEngine.FIRST_ROW || oneLevel)) {
            Function<DataFileMeta, Long> weightFunc = file -> Math.max(file.fileSize(), this.openFileCost);
            return BinPacking.packForOrdered(files, weightFunc, this.targetSplitSize).stream().map(SplitGenerator.SplitGroup::rawConvertibleGroup).collect(Collectors.toList());
        }
        List<List<DataFileMeta>> sections = new IntervalPartition(files, this.keyComparator).partition().stream().map(this::flatRun).collect(Collectors.toList());
        return this.packSplits(sections).stream().map(f -> f.size() == 1 && this.withoutDeleteRow((DataFileMeta)f.get(0)) ? SplitGenerator.SplitGroup.rawConvertibleGroup(f) : SplitGenerator.SplitGroup.nonRawConvertibleGroup(f)).collect(Collectors.toList());
    }

    @Override
    public List<SplitGenerator.SplitGroup> splitForStreaming(List<DataFileMeta> files) {
        return Collections.singletonList(SplitGenerator.SplitGroup.rawConvertibleGroup(files));
    }

    private List<List<DataFileMeta>> packSplits(List<List<DataFileMeta>> sections) {
        Function<List, Long> weightFunc = file -> Math.max(this.totalSize((List<DataFileMeta>)file), this.openFileCost);
        return BinPacking.packForOrdered(sections, weightFunc, this.targetSplitSize).stream().map(this::flatFiles).collect(Collectors.toList());
    }

    private long totalSize(List<DataFileMeta> section) {
        long size = 0L;
        for (DataFileMeta file : section) {
            size += file.fileSize();
        }
        return size;
    }

    private List<DataFileMeta> flatRun(List<SortedRun> section) {
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>();
        section.forEach(run -> files.addAll(run.files()));
        return files;
    }

    private List<DataFileMeta> flatFiles(List<List<DataFileMeta>> section) {
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>();
        section.forEach(files::addAll);
        return files;
    }

    private boolean withoutDeleteRow(DataFileMeta dataFileMeta) {
        return dataFileMeta.deleteRowCount().map(count -> count == 0L).orElse(true);
    }
}

