/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.append.AppendOnlyCompactManager;
import org.apache.paimon.append.AppendOnlyWriter;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.compact.NoopCompactManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.fileindex.FileIndexOptions;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.RowDataRollingFileWriter;
import org.apache.paimon.operation.AbstractFileStoreWrite;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.MemoryFileStoreWrite;
import org.apache.paimon.operation.RawFileSplitRead;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.reader.RecordReaderIterator;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CommitIncrement;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.LongCounter;
import org.apache.paimon.utils.RecordWriter;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.StatsCollectorFactories;

public class AppendOnlyFileStoreWrite
extends MemoryFileStoreWrite<InternalRow> {
    private final FileIO fileIO;
    private final RawFileSplitRead read;
    private final long schemaId;
    private final RowType rowType;
    private final FileFormat fileFormat;
    private final FileStorePathFactory pathFactory;
    private final long targetFileSize;
    private final int compactionMinFileNum;
    private final int compactionMaxFileNum;
    private final boolean commitForceCompact;
    private final String fileCompression;
    private final String spillCompression;
    private final boolean useWriteBuffer;
    private final boolean spillable;
    private final MemorySize maxDiskSize;
    private final FieldStatsCollector.Factory[] statsCollectors;
    private final FileIndexOptions fileIndexOptions;
    private boolean forceBufferSpill = false;
    private boolean skipCompaction;
    private BucketMode bucketMode = BucketMode.FIXED;

    public AppendOnlyFileStoreWrite(FileIO fileIO, RawFileSplitRead read, long schemaId, String commitUser, RowType rowType, FileStorePathFactory pathFactory, SnapshotManager snapshotManager, FileStoreScan scan, CoreOptions options, String tableName) {
        super(commitUser, snapshotManager, scan, options, null, null, tableName);
        this.fileIO = fileIO;
        this.read = read;
        this.schemaId = schemaId;
        this.rowType = rowType;
        this.fileFormat = options.fileFormat();
        this.pathFactory = pathFactory;
        this.targetFileSize = options.targetFileSize();
        this.compactionMinFileNum = options.compactionMinFileNum();
        this.compactionMaxFileNum = options.compactionMaxFileNum();
        this.commitForceCompact = options.commitForceCompact();
        this.skipCompaction = options.writeOnly();
        this.fileCompression = options.fileCompression();
        this.spillCompression = options.spillCompression();
        this.useWriteBuffer = options.useWriteBufferForAppend();
        this.spillable = options.writeBufferSpillable(fileIO.isObjectStore(), this.isStreamingMode);
        this.maxDiskSize = options.writeBufferSpillDiskSize();
        this.statsCollectors = StatsCollectorFactories.createStatsFactories(options, rowType.getFieldNames());
        this.fileIndexOptions = options.indexColumnsOptions();
    }

    @Override
    protected RecordWriter<InternalRow> createWriter(BinaryRow partition, int bucket, List<DataFileMeta> restoredFiles, long restoredMaxSeqNumber, @Nullable CommitIncrement restoreIncrement, ExecutorService compactExecutor, @Nullable DeletionVectorsMaintainer ignore) {
        DataFilePathFactory factory = this.pathFactory.createDataFilePathFactory(partition, bucket);
        CompactManager compactManager = this.skipCompaction ? new NoopCompactManager() : new AppendOnlyCompactManager(compactExecutor, restoredFiles, this.compactionMinFileNum, this.compactionMaxFileNum, this.targetFileSize, this.compactRewriter(partition, bucket), this.compactionMetrics == null ? null : this.compactionMetrics.createReporter(partition, bucket));
        return new AppendOnlyWriter(this.fileIO, this.ioManager, this.schemaId, this.fileFormat, this.targetFileSize, this.rowType, restoredMaxSeqNumber, compactManager, this.bucketReader(partition, bucket), this.commitForceCompact, factory, restoreIncrement, this.useWriteBuffer || this.forceBufferSpill, this.spillable || this.forceBufferSpill, this.fileCompression, this.spillCompression, this.statsCollectors, this.maxDiskSize, this.fileIndexOptions);
    }

    public AppendOnlyCompactManager.CompactRewriter compactRewriter(BinaryRow partition, int bucket) {
        return toCompact -> {
            if (toCompact.isEmpty()) {
                return Collections.emptyList();
            }
            try (RowDataRollingFileWriter rewriter = new RowDataRollingFileWriter(this.fileIO, this.schemaId, this.fileFormat, this.targetFileSize, this.rowType, this.pathFactory.createDataFilePathFactory(partition, bucket), new LongCounter(((DataFileMeta)toCompact.get(0)).minSequenceNumber()), this.fileCompression, this.statsCollectors, this.fileIndexOptions);){
                rewriter.write(this.bucketReader(partition, bucket).read(toCompact));
            }
            return rewriter.result();
        };
    }

    public BucketFileRead bucketReader(BinaryRow partition, int bucket) {
        return files -> new RecordReaderIterator<InternalRow>(this.read.createReader(DataSplit.builder().withPartition(partition).withBucket(bucket).withDataFiles(files).rawConvertible(true).withBucketPath(this.pathFactory.bucketPath(partition, bucket).toString()).build()));
    }

    public AppendOnlyFileStoreWrite withBucketMode(BucketMode bucketMode) {
        this.bucketMode = bucketMode;
        if (bucketMode == BucketMode.UNAWARE) {
            super.withIgnorePreviousFiles(true);
            this.skipCompaction = true;
        }
        return this;
    }

    @Override
    public void withIgnorePreviousFiles(boolean ignorePrevious) {
        super.withIgnorePreviousFiles(ignorePrevious || this.bucketMode == BucketMode.UNAWARE);
    }

    @Override
    protected void forceBufferSpill() throws Exception {
        this.forceBufferSpill = true;
        for (Map bucketWriters : this.writers.values()) {
            for (AbstractFileStoreWrite.WriterContainer writerContainer : bucketWriters.values()) {
                ((AppendOnlyWriter)writerContainer.writer).toBufferedWriter();
            }
        }
    }

    public static interface BucketFileRead {
        public RecordReaderIterator<InternalRow> read(List<DataFileMeta> var1) throws IOException;
    }
}

