/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.types.DataType;

public class FieldCountAgg
extends FieldAggregator {
    public static final String NAME = "count";

    public FieldCountAgg(DataType dataType) {
        super(dataType);
    }

    @Override
    String name() {
        return NAME;
    }

    @Override
    public Object agg(Object accumulator, Object inputField) {
        Object count;
        if (accumulator == null || inputField == null) {
            count = accumulator == null ? Integer.valueOf(inputField == null ? 0 : 1) : accumulator;
        } else {
            switch (this.fieldType.getTypeRoot()) {
                case INTEGER: {
                    count = (Integer)accumulator + 1;
                    break;
                }
                case BIGINT: {
                    count = (Long)accumulator + 1L;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return count;
    }

    @Override
    public Object retract(Object accumulator, Object inputField) {
        Object count;
        if (accumulator == null || inputField == null) {
            count = accumulator == null ? Integer.valueOf(inputField == null ? 0 : -1) : accumulator;
        } else {
            switch (this.fieldType.getTypeRoot()) {
                case INTEGER: {
                    count = (Integer)accumulator - 1;
                    break;
                }
                case BIGINT: {
                    count = (Long)accumulator - 1L;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return count;
    }
}

