/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.TableStatsCollector;
import org.apache.paimon.format.TableStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.SingleFileWriter;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public abstract class StatsCollectingSingleFileWriter<T, R>
extends SingleFileWriter<T, R> {
    @Nullable
    private final TableStatsExtractor tableStatsExtractor;
    @Nullable
    private TableStatsCollector tableStatsCollector = null;

    public StatsCollectingSingleFileWriter(FileIO fileIO, FormatWriterFactory factory, Path path, Function<T, InternalRow> converter, RowType writeSchema, @Nullable TableStatsExtractor tableStatsExtractor, String compression, FieldStatsCollector.Factory[] statsCollectors) {
        super(fileIO, factory, path, converter, compression);
        this.tableStatsExtractor = tableStatsExtractor;
        if (this.tableStatsExtractor == null) {
            this.tableStatsCollector = new TableStatsCollector(writeSchema, statsCollectors);
        }
        Preconditions.checkArgument(statsCollectors.length == writeSchema.getFieldCount(), "The stats collector is not aligned to write schema.");
    }

    @Override
    public void write(T record) throws IOException {
        InternalRow rowData = this.writeImpl(record);
        if (this.tableStatsCollector != null && !this.tableStatsCollector.isDisabled()) {
            this.tableStatsCollector.collect(rowData);
        }
    }

    public FieldStats[] fieldStats() throws IOException {
        Preconditions.checkState(this.closed, "Cannot access metric unless the writer is closed.");
        if (this.tableStatsExtractor != null) {
            return this.tableStatsExtractor.extract(this.fileIO, this.path);
        }
        return this.tableStatsCollector.extract();
    }
}

