/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fileindex.FileIndexOptions;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.TableStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.FileIndexWriter;
import org.apache.paimon.io.StatsCollectingSingleFileWriter;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.stats.FieldStatsArraySerializer;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.LongCounter;

public class RowDataFileWriter
extends StatsCollectingSingleFileWriter<InternalRow, DataFileMeta> {
    private final long schemaId;
    private final LongCounter seqNumCounter;
    private final FieldStatsArraySerializer statsArraySerializer;
    @Nullable
    private final FileIndexWriter fileIndexWriter;

    public RowDataFileWriter(FileIO fileIO, FormatWriterFactory factory, Path path, RowType writeSchema, @Nullable TableStatsExtractor tableStatsExtractor, long schemaId, LongCounter seqNumCounter, String fileCompression, FieldStatsCollector.Factory[] statsCollectors, FileIndexOptions fileIndexOptions) {
        super(fileIO, factory, path, Function.identity(), writeSchema, tableStatsExtractor, fileCompression, statsCollectors);
        this.schemaId = schemaId;
        this.seqNumCounter = seqNumCounter;
        this.statsArraySerializer = new FieldStatsArraySerializer(writeSchema);
        this.fileIndexWriter = FileIndexWriter.create(fileIO, DataFilePathFactory.toFileIndexPath(path), writeSchema, fileIndexOptions);
    }

    @Override
    public void write(InternalRow row) throws IOException {
        super.write(row);
        if (this.fileIndexWriter != null) {
            this.fileIndexWriter.write(row);
        }
        this.seqNumCounter.add(1L);
    }

    @Override
    public void close() throws IOException {
        if (this.fileIndexWriter != null) {
            this.fileIndexWriter.close();
        }
        super.close();
    }

    @Override
    public DataFileMeta result() throws IOException {
        BinaryTableStats stats = this.statsArraySerializer.toBinary(this.fieldStats());
        FileIndexWriter.FileIndexResult indexResult = this.fileIndexWriter == null ? FileIndexWriter.EMPTY_RESULT : this.fileIndexWriter.result();
        return DataFileMeta.forAppend(this.path.getName(), this.fileIO.getFileSize(this.path), this.recordCount(), stats, this.seqNumCounter.getValue() - super.recordCount(), this.seqNumCounter.getValue() - 1L, this.schemaId, indexResult.independentIndexFile() == null ? Collections.emptyList() : Collections.singletonList(indexResult.independentIndexFile()), indexResult.embeddedIndexBytes());
    }
}

