/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet;

import java.util.List;
import java.util.Optional;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.TableStatsExtractor;
import org.apache.paimon.format.parquet.ParquetReaderFactory;
import org.apache.paimon.format.parquet.ParquetSchemaConverter;
import org.apache.paimon.format.parquet.ParquetTableStatsExtractor;
import org.apache.paimon.format.parquet.ParquetWriterFactory;
import org.apache.paimon.format.parquet.writer.RowDataParquetBuilder;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.types.RowType;

public class ParquetFileFormat
extends FileFormat {
    private final FileFormatFactory.FormatContext formatContext;

    public ParquetFileFormat(FileFormatFactory.FormatContext formatContext) {
        super("parquet");
        this.formatContext = formatContext;
    }

    @VisibleForTesting
    Options formatOptions() {
        return this.formatContext.formatOptions();
    }

    @Override
    public FormatReaderFactory createReaderFactory(RowType projectedRowType, List<Predicate> filters) {
        return new ParquetReaderFactory(ParquetFileFormat.getParquetConfiguration(this.formatContext.formatOptions()), projectedRowType, this.formatContext.readBatchSize());
    }

    @Override
    public FormatWriterFactory createWriterFactory(RowType type) {
        return new ParquetWriterFactory(new RowDataParquetBuilder(type, ParquetFileFormat.getParquetConfiguration(this.formatContext.formatOptions())));
    }

    @Override
    public void validateDataFields(RowType rowType) {
        ParquetSchemaConverter.convertToParquetMessageType("paimon_schema", rowType);
    }

    @Override
    public Optional<TableStatsExtractor> createStatsExtractor(RowType type, FieldStatsCollector.Factory[] statsCollectors) {
        return Optional.of(new ParquetTableStatsExtractor(type, statsCollectors));
    }

    public static Options getParquetConfiguration(Options options) {
        Options conf = new Options();
        options.toMap().forEach((key, value) -> conf.setString("parquet." + key, (String)value));
        return conf;
    }
}

