/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tag;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.tag.TagPeriodHandler;
import org.apache.paimon.tag.TagTimeExtractor;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class TagPreview {
    private final TagTimeExtractor timeExtractor;
    private final TagPeriodHandler periodHandler;

    private TagPreview(CoreOptions options) {
        this.timeExtractor = TagTimeExtractor.createForTagPreview(options);
        this.periodHandler = TagPeriodHandler.create(options);
    }

    public static TagPreview create(CoreOptions options) {
        if (options.tagToPartitionPreview() != CoreOptions.TagCreationMode.NONE) {
            return new TagPreview(options);
        }
        return null;
    }

    public Optional<String> extractTag(long timeMilli, @Nullable Long watermark) {
        Optional<LocalDateTime> timeOptional = this.timeExtractor.extract(timeMilli, watermark);
        if (!timeOptional.isPresent()) {
            return Optional.empty();
        }
        LocalDateTime currentTag = this.periodHandler.nextTagTime(this.periodHandler.normalizeToPreviousTag(timeOptional.get()));
        String tag = this.periodHandler.timeToTag(currentTag);
        return Optional.of(tag);
    }

    public Map<String, String> timeTravel(FileStoreTable table, String tag) {
        TagManager tagManager = table.tagManager();
        if (tagManager.tagExists(tag)) {
            return Collections.singletonMap(CoreOptions.SCAN_TAG_NAME.key(), tag);
        }
        SnapshotManager snapshotManager = table.snapshotManager();
        Snapshot snapshot = snapshotManager.traversalSnapshotsFromLatestSafely(s -> this.extractTag(s.timeMillis(), s.watermark()).map(t -> t.compareTo(tag) <= 0).orElse(false));
        if (snapshot != null) {
            return Collections.singletonMap(CoreOptions.SCAN_SNAPSHOT_ID.key(), String.valueOf(snapshot.id()));
        }
        Optional<String> findTag = tagManager.tags().values().stream().filter(t -> t.compareTo(tag) <= 0).max(Comparator.naturalOrder());
        if (findTag.isPresent()) {
            return Collections.singletonMap(CoreOptions.SCAN_TAG_NAME.key(), findTag.get());
        }
        throw new RuntimeException("Cannot find snapshot or tag for tag name: " + tag);
    }
}

