/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatKey;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.RowDataFileRecordReader;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.operation.FileStoreRead;
import org.apache.paimon.partition.PartitionUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.IndexCastMapping;
import org.apache.paimon.schema.SchemaEvolutionUtil;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BulkFormatMapping;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Projection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendOnlyFileStoreRead
implements FileStoreRead<InternalRow> {
    private static final Logger LOG = LoggerFactory.getLogger(AppendOnlyFileStoreRead.class);
    private final FileIO fileIO;
    private final SchemaManager schemaManager;
    private final long schemaId;
    private final FileFormatDiscover formatDiscover;
    private final FileStorePathFactory pathFactory;
    private final Map<FormatKey, BulkFormatMapping> bulkFormatMappings;
    private int[][] projection;
    @Nullable
    private List<Predicate> filters;

    public AppendOnlyFileStoreRead(FileIO fileIO, SchemaManager schemaManager, long schemaId, RowType rowType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory) {
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.schemaId = schemaId;
        this.formatDiscover = formatDiscover;
        this.pathFactory = pathFactory;
        this.bulkFormatMappings = new HashMap<FormatKey, BulkFormatMapping>();
        this.projection = Projection.range(0, rowType.getFieldCount()).toNestedIndexes();
    }

    public FileStoreRead<InternalRow> withProjection(int[][] projectedFields) {
        this.projection = projectedFields;
        return this;
    }

    @Override
    public FileStoreRead<InternalRow> withFilter(Predicate predicate) {
        this.filters = PredicateBuilder.splitAnd(predicate);
        return this;
    }

    @Override
    public RecordReader<InternalRow> createReader(DataSplit split) throws IOException {
        DataFilePathFactory dataFilePathFactory = this.pathFactory.createDataFilePathFactory(split.partition(), split.bucket());
        ArrayList suppliers = new ArrayList();
        if (split.beforeFiles().size() > 0) {
            LOG.info("Ignore split before files: " + split.beforeFiles());
        }
        for (DataFileMeta file : split.dataFiles()) {
            String formatIdentifier = DataFilePathFactory.formatIdentifier(file.fileName());
            BulkFormatMapping bulkFormatMapping = this.bulkFormatMappings.computeIfAbsent(new FormatKey(file.schemaId(), formatIdentifier), key -> {
                Pair<int[], int[][]> partitionMappping;
                TableSchema tableSchema = this.schemaManager.schema(this.schemaId);
                TableSchema dataSchema = this.schemaManager.schema(key.schemaId);
                int[][] dataProjection = SchemaEvolutionUtil.createDataProjection(tableSchema.fields(), dataSchema.fields(), this.projection);
                IndexCastMapping indexCastMapping = SchemaEvolutionUtil.createIndexCastMapping(Projection.of(this.projection).toTopLevelIndexes(), tableSchema.fields(), Projection.of(dataProjection).toTopLevelIndexes(), dataSchema.fields());
                List<Predicate> dataFilters = this.schemaId == key.schemaId ? this.filters : SchemaEvolutionUtil.createDataFilters(tableSchema.fields(), dataSchema.fields(), this.filters);
                Pair<int[], RowType> partitionPair = null;
                if (!dataSchema.partitionKeys().isEmpty() && (partitionMappping = PartitionUtils.constructPartitionMapping(dataSchema, dataProjection)) != null) {
                    dataProjection = partitionMappping.getRight();
                    partitionPair = Pair.of(partitionMappping.getLeft(), dataSchema.projectedLogicalRowType(dataSchema.partitionKeys()));
                }
                RowType projectedRowType = Projection.of(dataProjection).project(dataSchema.logicalRowType());
                return new BulkFormatMapping(indexCastMapping.getIndexMapping(), indexCastMapping.getCastMapping(), partitionPair, this.formatDiscover.discover(formatIdentifier).createReaderFactory(projectedRowType, dataFilters));
            });
            BinaryRow partition = split.partition();
            suppliers.add(() -> new RowDataFileRecordReader(this.fileIO, dataFilePathFactory.toPath(file.fileName()), bulkFormatMapping.getReaderFactory(), bulkFormatMapping.getIndexMapping(), bulkFormatMapping.getCastMapping(), PartitionUtils.create(bulkFormatMapping.getPartitionPair(), partition)));
        }
        return ConcatRecordReader.create(suppliers);
    }
}

