/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.migrate;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryRowWriter;
import org.apache.paimon.data.BinaryWriter;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.TableStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.NewFilesIncrement;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.stats.FieldStatsArraySerializer;
import org.apache.paimon.table.AbstractFileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.StatsCollectorFactories;
import org.apache.paimon.utils.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileMetaUtils.class);

    public static List<DataFileMeta> construct(FileIO fileIO, String format, String location, Table paimonTable, Predicate<FileStatus> filter, Path dir, Map<Path, Path> rollback) throws IOException {
        List fileStatuses = Arrays.stream(fileIO.listStatus(new Path(location))).filter(s -> !s.isDir()).filter(filter).collect(Collectors.toList());
        return fileStatuses.stream().map(status -> FileMetaUtils.constructFileMeta(format, status, fileIO, paimonTable, dir, rollback)).collect(Collectors.toList());
    }

    public static CommitMessage commitFile(BinaryRow partition, List<DataFileMeta> dataFileMetas) {
        return new CommitMessageImpl(partition, 0, new NewFilesIncrement(dataFileMetas, Collections.emptyList()), new CompactIncrement(Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
    }

    private static DataFileMeta constructFileMeta(String format, FileStatus fileStatus, FileIO fileIO, Table table, Path dir, Map<Path, Path> rollback) {
        try {
            FieldStatsCollector.Factory[] factories = StatsCollectorFactories.createStatsFactories(((AbstractFileStoreTable)table).coreOptions(), table.rowType().getFieldNames());
            TableStatsExtractor tableStatsExtractor = FileFormat.getFileFormat(((AbstractFileStoreTable)table).coreOptions().toConfiguration(), format).createStatsExtractor(table.rowType(), factories).orElseThrow(() -> new RuntimeException("Can't get table stats extractor for format " + format));
            Path newPath = FileMetaUtils.renameFile(fileIO, fileStatus.getPath(), dir, format, rollback);
            return FileMetaUtils.constructFileMeta(newPath.getName(), fileStatus.getLen(), newPath, tableStatsExtractor, fileIO, table);
        }
        catch (IOException e) {
            throw new RuntimeException("error when construct file meta", e);
        }
    }

    private static Path renameFile(FileIO fileIO, Path originPath, Path newDir, String format, Map<Path, Path> rollback) throws IOException {
        String subfix = "." + format;
        String fileName = originPath.getName();
        String newFileName = fileName.endsWith(subfix) ? fileName : fileName + "." + format;
        Path newPath = new Path(newDir, newFileName);
        rollback.put(newPath, originPath);
        LOG.info("Migration: rename file from " + originPath + " to " + newPath);
        fileIO.rename(originPath, newPath);
        return newPath;
    }

    private static DataFileMeta constructFileMeta(String fileName, long fileSize, Path path, TableStatsExtractor tableStatsExtractor, FileIO fileIO, Table table) throws IOException {
        FieldStatsArraySerializer statsArraySerializer = new FieldStatsArraySerializer(table.rowType());
        Pair<FieldStats[], TableStatsExtractor.FileInfo> fileInfo = tableStatsExtractor.extractWithFileInfo(fileIO, path);
        BinaryTableStats stats = statsArraySerializer.toBinary(fileInfo.getLeft());
        return DataFileMeta.forAppend(fileName, fileSize, fileInfo.getRight().getRowCount(), stats, 0L, 0L, ((AbstractFileStoreTable)table).schema().id());
    }

    public static BinaryRow writePartitionValue(RowType partitionRowType, Map<String, String> partitionValues, List<BinaryWriter.ValueSetter> valueSetters) {
        BinaryRow binaryRow = new BinaryRow(partitionRowType.getFieldCount());
        BinaryRowWriter binaryRowWriter = new BinaryRowWriter(binaryRow);
        List<DataField> fields = partitionRowType.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Object value = TypeUtils.castFromString(partitionValues.get(fields.get(i).name()), fields.get(i).type());
            valueSetters.get(i).setValue(binaryRowWriter, i, value);
        }
        binaryRowWriter.complete();
        return binaryRow;
    }
}

