/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Comparator;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.RowCompactedSerializer;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.lookup.LookupStoreFactory;
import org.apache.paimon.lookup.LookupStoreReader;
import org.apache.paimon.lookup.LookupStoreWriter;
import org.apache.paimon.mergetree.Levels;
import org.apache.paimon.mergetree.LookupUtils;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.RemovalCause;
import org.apache.paimon.shade.guava30.com.google.common.util.concurrent.MoreExecutors;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileIOUtils;
import org.apache.paimon.utils.IOFunction;
import org.apache.paimon.utils.Preconditions;

public class ContainsLevels
implements Levels.DropFileCallback,
Closeable {
    private static final byte[] EMPTY_VALUE = new byte[0];
    private final Levels levels;
    private final Comparator<InternalRow> keyComparator;
    private final RowCompactedSerializer keySerializer;
    private final IOFunction<DataFileMeta, RecordReader<KeyValue>> fileReaderFactory;
    private final Supplier<File> localFileFactory;
    private final LookupStoreFactory lookupStoreFactory;
    private final Cache<String, ContainsFile> containsFiles;

    public ContainsLevels(Levels levels, Comparator<InternalRow> keyComparator, RowType keyType, IOFunction<DataFileMeta, RecordReader<KeyValue>> fileReaderFactory, Supplier<File> localFileFactory, LookupStoreFactory lookupStoreFactory, Duration fileRetention, MemorySize maxDiskSize) {
        this.levels = levels;
        this.keyComparator = keyComparator;
        this.keySerializer = new RowCompactedSerializer(keyType);
        this.fileReaderFactory = fileReaderFactory;
        this.localFileFactory = localFileFactory;
        this.lookupStoreFactory = lookupStoreFactory;
        this.containsFiles = Caffeine.newBuilder().expireAfterAccess(fileRetention).maximumWeight(maxDiskSize.getKibiBytes()).weigher(this::fileWeigh).removalListener(this::removalCallback).executor(MoreExecutors.directExecutor()).build();
        levels.addDropFileCallback(this);
    }

    @VisibleForTesting
    Cache<String, ContainsFile> containsFiles() {
        return this.containsFiles;
    }

    @Override
    public void notifyDropFile(String file) {
        this.containsFiles.invalidate(file);
    }

    public boolean contains(InternalRow key, int startLevel) throws IOException {
        Boolean result = LookupUtils.lookup(this.levels, key, startLevel, this::contains);
        return result != null && result != false;
    }

    @Nullable
    private Boolean contains(InternalRow key, SortedRun level) throws IOException {
        return LookupUtils.lookup(this.keyComparator, key, level, this::contains);
    }

    @Nullable
    private Boolean contains(InternalRow key, DataFileMeta file) throws IOException {
        ContainsFile containsFile = this.containsFiles.getIfPresent(file.fileName());
        while (containsFile == null || containsFile.isClosed) {
            containsFile = this.createContainsFile(file);
            this.containsFiles.put(file.fileName(), containsFile);
        }
        if (containsFile.get(this.keySerializer.serializeToBytes(key)) != null) {
            return true;
        }
        return null;
    }

    private int fileWeigh(String file, ContainsFile containsFile) {
        return LookupUtils.fileKibiBytes(containsFile.localFile);
    }

    private void removalCallback(String key, ContainsFile file, RemovalCause cause) {
        if (file != null) {
            try {
                file.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private ContainsFile createContainsFile(DataFileMeta file) throws IOException {
        File localFile = this.localFileFactory.get();
        if (!localFile.createNewFile()) {
            throw new IOException("Can not create new file: " + localFile);
        }
        try (LookupStoreWriter kvWriter = this.lookupStoreFactory.createWriter(localFile);
             RecordReader<KeyValue> reader = this.fileReaderFactory.apply(file);){
            RecordReader.RecordIterator<KeyValue> batch;
            while ((batch = reader.readBatch()) != null) {
                KeyValue kv;
                while ((kv = batch.next()) != null) {
                    byte[] keyBytes = this.keySerializer.serializeToBytes(kv.key());
                    kvWriter.put(keyBytes, EMPTY_VALUE);
                }
                batch.releaseBatch();
            }
        }
        catch (IOException e) {
            FileIOUtils.deleteFileOrDirectory(localFile);
            throw e;
        }
        return new ContainsFile(localFile, this.lookupStoreFactory.createReader(localFile));
    }

    @Override
    public void close() throws IOException {
        this.containsFiles.invalidateAll();
    }

    private static class ContainsFile
    implements Closeable {
        private final File localFile;
        private final LookupStoreReader reader;
        private boolean isClosed = false;

        public ContainsFile(File localFile, LookupStoreReader reader) {
            this.localFile = localFile;
            this.reader = reader;
        }

        @Nullable
        public byte[] get(byte[] key) throws IOException {
            Preconditions.checkArgument(!this.isClosed);
            return this.reader.lookup(key);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
            this.isClosed = true;
            FileIOUtils.deleteFileOrDirectory(this.localFile);
        }
    }
}

