/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.paimon.hive.objectinspector.WriteableObjectInspector;

public class PaimonTimestampObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements TimestampObjectInspector,
WriteableObjectInspector {
    public PaimonTimestampObjectInspector() {
        super(TypeInfoFactory.timestampTypeInfo);
    }

    public Timestamp getPrimitiveJavaObject(Object o) {
        return o == null ? null : ((org.apache.paimon.data.Timestamp)o).toSQLTimestamp();
    }

    public TimestampWritable getPrimitiveWritableObject(Object o) {
        Timestamp ts = this.getPrimitiveJavaObject(o);
        return ts == null ? null : new TimestampWritable(ts);
    }

    public Object copyObject(Object o) {
        if (o instanceof org.apache.paimon.data.Timestamp) {
            return o;
        }
        if (o instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)o;
            return new Timestamp(timestamp.getTime());
        }
        return o;
    }

    @Override
    public org.apache.paimon.data.Timestamp convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return org.apache.paimon.data.Timestamp.fromSQLTimestamp((Timestamp)value);
        }
        if (value instanceof TimestampWritable) {
            return org.apache.paimon.data.Timestamp.fromSQLTimestamp(((TimestampWritable)value).getTimestamp());
        }
        return org.apache.paimon.data.Timestamp.fromLocalDateTime((LocalDateTime)value);
    }
}

