/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.mapred;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.JoinedRow;
import org.apache.paimon.hive.RowDataContainer;
import org.apache.paimon.hive.mapred.PaimonInputFormat;
import org.apache.paimon.hive.mapred.PaimonInputSplit;
import org.apache.paimon.reader.RecordReaderIterator;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.utils.ProjectedRow;

public class PaimonRecordReader
implements RecordReader<Void, RowDataContainer> {
    private final RecordReaderIterator<InternalRow> iterator;
    private final long splitLength;
    @Nullable
    private final ProjectedRow reusedProjectedRow;
    @Nullable
    private final JoinedRow addTagToPartFieldRow;
    private float progress;

    public PaimonRecordReader(ReadBuilder readBuilder, PaimonInputSplit split, List<String> paimonColumns, List<String> hiveColumns, List<String> selectedColumns, @Nullable String tagToPartField) throws IOException {
        if (!paimonColumns.equals(selectedColumns)) {
            readBuilder.withProjection(selectedColumns.stream().mapToInt(paimonColumns::indexOf).toArray());
        }
        this.reusedProjectedRow = hiveColumns.equals(selectedColumns) ? null : ProjectedRow.from(hiveColumns.stream().mapToInt(selectedColumns::indexOf).toArray());
        this.iterator = new RecordReaderIterator<InternalRow>(readBuilder.newRead().createReader(split.split()));
        this.splitLength = split.getLength();
        if (tagToPartField != null) {
            String tag = PaimonInputFormat.extractTagName(split.getPath().getName(), tagToPartField);
            this.addTagToPartFieldRow = new JoinedRow();
            this.addTagToPartFieldRow.replace(null, GenericRow.of(BinaryString.fromString(tag)));
        } else {
            this.addTagToPartFieldRow = null;
        }
        this.progress = 0.0f;
    }

    public boolean next(Void key, RowDataContainer value) throws IOException {
        InternalRow rowData = this.iterator.next();
        if (rowData == null) {
            this.progress = 1.0f;
            return false;
        }
        if (this.reusedProjectedRow != null) {
            value.set(this.reusedProjectedRow.replaceRow(rowData));
        } else {
            value.set(rowData);
        }
        if (this.addTagToPartFieldRow != null) {
            value.set(this.addTagToPartFieldRow.replace(value.get(), this.addTagToPartFieldRow.row2()));
        }
        return true;
    }

    public Void createKey() {
        return null;
    }

    public RowDataContainer createValue() {
        return new RowDataContainer();
    }

    public long getPos() throws IOException {
        return (long)((float)this.splitLength * this.getProgress());
    }

    public void close() throws IOException {
        try {
            this.iterator.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public float getProgress() throws IOException {
        return this.progress;
    }
}

