/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.mapred;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.hive.RowDataContainer;
import org.apache.paimon.hive.mapred.PaimonRecordWriter;
import org.apache.paimon.hive.utils.HiveUtils;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.BatchTableWrite;
import org.apache.paimon.table.sink.BatchWriteBuilder;

public class PaimonOutputFormat
implements OutputFormat<NullWritable, RowDataContainer>,
HiveOutputFormat<NullWritable, RowDataContainer> {
    private static final String TASK_ATTEMPT_ID_KEY = "mapreduce.task.attempt.id";

    public RecordWriter<NullWritable, RowDataContainer> getRecordWriter(FileSystem fileSystem, JobConf jobConf, String s, Progressable progressable) throws IOException {
        return PaimonOutputFormat.writer(jobConf);
    }

    public void checkOutputSpecs(FileSystem fileSystem, JobConf jobConf) throws IOException {
    }

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jobConf, Path path, Class<? extends Writable> aClass, boolean b, Properties properties, Progressable progressable) throws IOException {
        return PaimonOutputFormat.writer(jobConf);
    }

    private static PaimonRecordWriter writer(JobConf jobConf) {
        TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)jobConf.get(TASK_ATTEMPT_ID_KEY));
        FileStoreTable table = HiveUtils.createFileStoreTable(jobConf);
        Map<String, String> newOptions = Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), Boolean.TRUE.toString());
        Table copy = table.copy((Map)newOptions);
        BatchWriteBuilder batchWriteBuilder = copy.newBatchWriteBuilder();
        BatchTableWrite batchTableWrite = batchWriteBuilder.newWrite();
        return new PaimonRecordWriter(batchTableWrite, taskAttemptID, copy.name());
    }
}

