/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.mapred;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.mapred.PaimonRecordWriter;
import org.apache.paimon.hive.utils.HiveUtils;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.BatchTableWrite;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.CommitMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaimonOutputCommitter
extends OutputCommitter {
    private static final String PRE_COMMIT = ".preCommit";
    private static final Logger LOG = LoggerFactory.getLogger(PaimonOutputCommitter.class);

    public void setupJob(JobContext jobContext) throws IOException {
    }

    public void setupTask(TaskAttemptContext taskAttemptContext) throws IOException {
    }

    public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext) throws IOException {
        return TaskType.REDUCE.equals((Object)taskAttemptContext.getTaskAttemptID().getTaskID().getTaskType()) || taskAttemptContext.getJobConf().getNumReduceTasks() == 0;
    }

    public void commitTask(TaskAttemptContext taskAttemptContext) throws IOException {
        TaskAttemptID attemptID;
        block15: {
            attemptID = taskAttemptContext.getTaskAttemptID();
            JobConf jobConf = taskAttemptContext.getJobConf();
            FileStoreTable table = HiveUtils.createFileStoreTable(jobConf);
            Map writers = Optional.ofNullable(PaimonRecordWriter.getWriters(attemptID)).orElseGet(() -> {
                LOG.info("CommitTask found no writers for output table: {}, attemptID: {}", (Object)table.name(), (Object)attemptID);
                return ImmutableMap.of();
            });
            PaimonRecordWriter writer = (PaimonRecordWriter)writers.get(table.name());
            if (writer != null) {
                try (BatchTableWrite batchTableWrite = writer.batchTableWrite();){
                    List<CommitMessage> commitTables = batchTableWrite.prepareCommit();
                    PaimonOutputCommitter.createPreCommitFile(commitTables, PaimonOutputCommitter.generatePreCommitFileLocation(table.location(), (JobID)attemptID.getJobID(), attemptID.getTaskID().getId()), table.fileIO());
                    writer.close(true);
                    break block15;
                }
                catch (Exception e) {
                    LOG.error("CommitTask prepareCommit error for specific table: {}, attemptID: {}", (Object)table.name(), (Object)attemptID);
                    throw new RuntimeException(e);
                }
            }
            LOG.info("CommitTask found no writer for specific table: {}, attemptID: {}", (Object)table.name(), (Object)attemptID);
        }
        PaimonRecordWriter.removeWriters(attemptID);
    }

    public void abortTask(TaskAttemptContext taskAttemptContext) throws IOException {
        Map<String, PaimonRecordWriter> writers = PaimonRecordWriter.removeWriters(taskAttemptContext.getTaskAttemptID());
        if (writers != null) {
            for (PaimonRecordWriter writer : writers.values()) {
                writer.close(true);
            }
        }
    }

    public void commitJob(JobContext jobContext) throws IOException {
        JobConf jobConf = jobContext.getJobConf();
        long startTime = System.currentTimeMillis();
        LOG.info("CommitJob {} has started", (Object)jobContext.getJobID());
        FileStoreTable table = HiveUtils.createFileStoreTable(jobConf);
        if (table != null) {
            BatchWriteBuilder batchWriteBuilder = table.newBatchWriteBuilder();
            List<CommitMessage> commitMessagesList = PaimonOutputCommitter.getAllPreCommitMessage(table.location(), jobContext, table.fileIO());
            try (BatchTableCommit batchTableCommit = batchWriteBuilder.newCommit();){
                batchTableCommit.commit(commitMessagesList);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.deleteTemporaryFile(jobContext, PaimonOutputCommitter.generateJobLocation(table.location(), jobContext.getJobID()), table.fileIO());
        } else {
            LOG.info("CommitJob not found table, Skipping job commit.");
        }
        LOG.info("Commit took {} ms for job {}", (Object)(System.currentTimeMillis() - startTime), (Object)jobContext.getJobID());
    }

    public void abortJob(JobContext jobContext, int status) throws IOException {
        FileStoreTable table = HiveUtils.createFileStoreTable(jobContext.getJobConf());
        if (table != null) {
            LOG.info("AbortJob {} has started", (Object)jobContext.getJobID());
            List<CommitMessage> commitMessagesList = PaimonOutputCommitter.getAllPreCommitMessage(table.location(), jobContext, table.fileIO());
            BatchWriteBuilder batchWriteBuilder = table.newBatchWriteBuilder();
            try (BatchTableCommit batchTableCommit = batchWriteBuilder.newCommit();){
                batchTableCommit.abort(commitMessagesList);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.deleteTemporaryFile(jobContext, PaimonOutputCommitter.generateJobLocation(table.location(), jobContext.getJobID()), table.fileIO());
            LOG.info("Job {} is aborted. preCommit file has deleted", (Object)jobContext.getJobID());
        }
    }

    private void deleteTemporaryFile(JobContext jobContext, Path location, FileIO fileIO) {
        LOG.info("Deleting temporary file for job {} started", (Object)jobContext.getJobID());
        LOG.info("The deleted file is located in : {}", (Object)location);
        try {
            fileIO.delete(location, true);
        }
        catch (IOException e) {
            LOG.debug("Failed to delete directory {} ", (Object)location, (Object)e);
        }
        LOG.info("Deleting temporary file for job {} finished", (Object)jobContext.getJobID());
    }

    private static List<CommitMessage> getAllPreCommitMessage(Path location, JobContext jobContext, FileIO io) {
        JobConf conf = jobContext.getJobConf();
        int totalCommitMessagesSize = conf.getNumReduceTasks() > 0 ? conf.getNumReduceTasks() : conf.getNumMapTasks();
        List<CommitMessage> commitMessagesList = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < totalCommitMessagesSize; ++i) {
            Path commitFileLocation = PaimonOutputCommitter.generatePreCommitFileLocation(location, jobContext.getJobID(), i);
            commitMessagesList.addAll(PaimonOutputCommitter.readPreCommitFile(commitFileLocation, io));
        }
        return commitMessagesList;
    }

    static Path generateJobLocation(Path location, JobID jobId) {
        return new Path(new Path(location, "temp"), jobId.toString());
    }

    private static Path generatePreCommitFileLocation(Path location, JobID jobId, int taskId) {
        return new Path(PaimonOutputCommitter.generateJobLocation(location, jobId), "task_" + taskId + PRE_COMMIT);
    }

    private static void createPreCommitFile(List<CommitMessage> commitTables, Path location, FileIO io) throws IOException {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(io.newOutputStream(location, true));){
            objectOutputStream.writeObject(commitTables);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<CommitMessage> readPreCommitFile(Path location, FileIO io) {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(io.newInputStream(location));){
            List list = (List)objectInputStream.readObject();
            return list;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(String.format("Can not read or parse CommitMessage file: %s", location));
        }
    }
}

