/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.hive.LocationKeyExtractor;
import org.apache.paimon.hive.utils.HiveUtils;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.base.Splitter;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSchema {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSchema.class);
    private final RowType rowType;

    private HiveSchema(RowType rowType) {
        this.rowType = rowType;
    }

    public RowType rowType() {
        return this.rowType;
    }

    public List<String> fieldNames() {
        return this.rowType.getFieldNames();
    }

    public List<DataType> fieldTypes() {
        return this.rowType.getFieldTypes();
    }

    public List<DataField> fields() {
        return this.rowType.getFields();
    }

    public List<String> fieldComments() {
        return this.rowType.getFields().stream().map(DataField::description).collect(Collectors.toList());
    }

    public static HiveSchema extract(@Nullable Configuration configuration, Properties properties) {
        ArrayList<String> comments;
        String location = LocationKeyExtractor.getPaimonLocation(configuration, properties);
        Optional<TableSchema> tableSchema = HiveSchema.getExistingSchema(configuration, location);
        String columnProperty = properties.getProperty("columns");
        if (StringUtils.isEmpty(columnProperty)) {
            if (!tableSchema.isPresent()) {
                throw new IllegalArgumentException("Schema file not found in location " + location + ". Please create table first.");
            }
            return new HiveSchema(new RowType(tableSchema.get().fields()));
        }
        String columnNameDelimiter = properties.getProperty("column.name.delimite", String.valueOf(','));
        List<String> columnNames = Arrays.asList(columnProperty.split(columnNameDelimiter));
        String columnTypes = properties.getProperty("columns.types");
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypes);
        List dataTypes = typeInfos.stream().map(HiveTypeUtils::toPaimonType).collect(Collectors.toList());
        String partitionProperty = properties.getProperty("partition_columns");
        List<String> partitionKeys = StringUtils.isEmpty(partitionProperty) ? Collections.emptyList() : Arrays.asList(partitionProperty.split("/"));
        String partitionTypes = properties.getProperty("partition_columns.types");
        ArrayList partitionTypeInfos = StringUtils.isEmpty(partitionTypes) ? Collections.emptyList() : TypeInfoUtils.getTypeInfosFromTypeString((String)partitionTypes);
        String commentProperty = properties.getProperty("columns.comments");
        List<String> list = comments = StringUtils.isEmpty(commentProperty) ? IntStream.range(0, columnNames.size()).mapToObj(i -> "").collect(Collectors.toList()) : Lists.newArrayList(Splitter.on('\u0000').split(commentProperty));
        if (tableSchema.isPresent() && columnNames.size() > 0 && typeInfos.size() > 0) {
            LOG.debug("Extract schema with exists DDL and exists paimon table, table location:[{}].", (Object)location);
            TableSchema paimonSchema = tableSchema.get();
            String tagToPartField = paimonSchema.options().get(CoreOptions.METASTORE_TAG_TO_PARTITION.key());
            boolean isPartitionedTable = partitionTypeInfos.size() > 0 || properties.containsKey("TABLE_TOTAL_PARTITIONS");
            HiveSchema.checkFieldsMatched(columnNames, typeInfos, paimonSchema, isPartitionedTable);
            HiveSchema.checkPartitionMatched(partitionKeys, partitionTypeInfos, paimonSchema, tagToPartField);
            Map paimonFields = paimonSchema.fields().stream().collect(Collectors.toMap(dataField -> dataField.name().toLowerCase(), Function.identity()));
            for (int i2 = 0; i2 < columnNames.size(); ++i2) {
                String columnName = columnNames.get(i2).toLowerCase();
                if (Objects.equals(columnName, tagToPartField)) continue;
                dataTypes.set(i2, ((DataField)paimonFields.get(columnName)).type());
                comments.set(i2, ((DataField)paimonFields.get(columnName)).description());
            }
        }
        RowType.Builder builder = RowType.builder();
        for (int i3 = 0; i3 < columnNames.size(); ++i3) {
            builder.field(columnNames.get(i3), (DataType)dataTypes.get(i3), (String)comments.get(i3));
        }
        return new HiveSchema(builder.build());
    }

    private static Optional<TableSchema> getExistingSchema(@Nullable Configuration configuration, @Nullable String location) {
        if (location == null) {
            return Optional.empty();
        }
        Path path = new Path(location);
        Options options = HiveUtils.extractCatalogConfig(configuration);
        options.set(CoreOptions.PATH, location);
        CatalogContext context = CatalogContext.create(options, configuration);
        try {
            return new SchemaManager(FileIO.get(path, context), path).latest();
        }
        catch (IOException e) {
            LOG.warn("Failed to fetch Paimon table schema from path " + path + ", relying on Hive DDL instead.", (Throwable)e);
            return Optional.empty();
        }
    }

    private static void checkFieldsMatched(List<String> hiveFieldNames, List<TypeInfo> hiveFieldTypeInfos, TableSchema tableSchema, boolean isPartitionedTable) {
        HashSet<String> schemaPartitionKeySet = new HashSet<String>(tableSchema.partitionKeys());
        ArrayList<String> schemaFieldNames = new ArrayList<String>();
        ArrayList<TypeInfo> schemaFieldTypeInfos = new ArrayList<TypeInfo>();
        for (DataField field : tableSchema.fields()) {
            boolean isPartitionColumn = isPartitionedTable && schemaPartitionKeySet.contains(field.name());
            if (isPartitionColumn) continue;
            schemaFieldNames.add(field.name());
            schemaFieldTypeInfos.add(HiveTypeUtils.toTypeInfo(field.type()));
        }
        if (schemaFieldNames.size() != hiveFieldNames.size()) {
            throw new IllegalArgumentException("Hive DDL and paimon schema mismatched! It is recommended not to write any column definition as Paimon external table can read schema from the specified location.\nThere are " + hiveFieldNames.size() + " fields in Hive DDL: " + String.join((CharSequence)", ", hiveFieldNames) + "\nThere are " + schemaFieldNames.size() + " fields in Paimon schema: " + String.join((CharSequence)", ", schemaFieldNames) + "\n");
        }
        ArrayList<String> mismatched = new ArrayList<String>();
        for (int i = 0; i < hiveFieldNames.size(); ++i) {
            if (hiveFieldNames.get(i).equalsIgnoreCase((String)schemaFieldNames.get(i)) && Objects.equals(hiveFieldTypeInfos.get(i), schemaFieldTypeInfos.get(i))) continue;
            String ddlField = hiveFieldNames.get(i) + " " + hiveFieldTypeInfos.get(i).getTypeName();
            String schemaField = (String)schemaFieldNames.get(i) + " " + ((TypeInfo)schemaFieldTypeInfos.get(i)).getTypeName();
            mismatched.add(String.format("Field #%d\nHive DDL          : %s\nPaimon Schema: %s\n", i + 1, ddlField, schemaField));
        }
        if (mismatched.size() > 0) {
            throw new IllegalArgumentException("Hive DDL and paimon schema mismatched! It is recommended not to write any column definition as Paimon external table can read schema from the specified location.\nMismatched fields are:\n" + String.join((CharSequence)"--------------------\n", mismatched));
        }
    }

    private static void checkPartitionMatched(List<String> hivePartitionKeys, List<TypeInfo> hivePartitionTypeInfos, TableSchema tableSchema, @Nullable String tagToPartField) {
        if (hivePartitionKeys.isEmpty()) {
            return;
        }
        if (tagToPartField != null) {
            Preconditions.checkArgument(tableSchema.partitionKeys().isEmpty());
            Preconditions.checkArgument(hivePartitionKeys.equals(Collections.singletonList(tagToPartField)));
            return;
        }
        List<String> schemaPartitionKeys = tableSchema.partitionKeys();
        List schemaPartitionTypeInfos = tableSchema.logicalPartitionType().getFields().stream().map(f -> HiveTypeUtils.toTypeInfo(f.type())).collect(Collectors.toList());
        if (schemaPartitionKeys.size() != hivePartitionKeys.size()) {
            throw new IllegalArgumentException("Hive DDL and paimon schema mismatched! It is recommended not to write any column definition as Paimon external table can read schema from the specified location.\nThere are " + hivePartitionKeys.size() + " partition keys in Hive DDL: " + String.join((CharSequence)", ", hivePartitionKeys) + "\nThere are " + schemaPartitionKeys.size() + " partition keys in Paimon schema: " + String.join((CharSequence)", ", schemaPartitionKeys) + "\n");
        }
        ArrayList<String> mismatched = new ArrayList<String>();
        for (int i = 0; i < hivePartitionKeys.size(); ++i) {
            if (hivePartitionKeys.get(i).equalsIgnoreCase(schemaPartitionKeys.get(i)) && Objects.equals(hivePartitionTypeInfos.get(i), schemaPartitionTypeInfos.get(i))) continue;
            String ddlField = hivePartitionKeys.get(i) + " " + hivePartitionTypeInfos.get(i).getTypeName();
            String schemaField = schemaPartitionKeys.get(i) + " " + ((TypeInfo)schemaPartitionTypeInfos.get(i)).getTypeName();
            mismatched.add(String.format("Partition Key #%d\nHive DDL          : %s\nPaimon Schema: %s\n", i + 1, ddlField, schemaField));
        }
        if (mismatched.size() > 0) {
            throw new IllegalArgumentException("Hive DDL and paimon schema mismatched! It is recommended not to write any column definition as Paimon external table can read schema from the specified location.\nMismatched partition keys are:\n" + String.join((CharSequence)"--------------------\n", mismatched));
        }
    }
}

