/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet;

import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.shade.org.apache.parquet.schema.ConversionPatterns;
import org.apache.paimon.shade.org.apache.parquet.schema.GroupType;
import org.apache.paimon.shade.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.paimon.shade.org.apache.parquet.schema.MessageType;
import org.apache.paimon.shade.org.apache.parquet.schema.OriginalType;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.shade.org.apache.parquet.schema.Type;
import org.apache.paimon.shade.org.apache.parquet.schema.Types;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;

public class ParquetSchemaConverter {
    static final String MAP_REPEATED_NAME = "key_value";
    static final String LIST_ELEMENT_NAME = "element";

    public static MessageType convertToParquetMessageType(String name, RowType rowType) {
        Type[] types = new Type[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            types[i] = ParquetSchemaConverter.convertToParquetType(rowType.getFieldNames().get(i), rowType.getTypeAt(i));
        }
        return new MessageType(name, types);
    }

    public static Type convertToParquetType(String name, DataType type) {
        return ParquetSchemaConverter.convertToParquetType(name, type, Type.Repetition.OPTIONAL);
    }

    private static Type convertToParquetType(String name, DataType type, Type.Repetition repetition) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.UTF8)).named(name);
            }
            case BOOLEAN: {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition).named(name);
            }
            case BINARY: 
            case VARBINARY: {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).named(name);
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                if (ParquetSchemaConverter.is32BitDecimal(precision)) {
                    return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(LogicalTypeAnnotation.decimalType(scale, precision))).named(name);
                }
                if (ParquetSchemaConverter.is64BitDecimal(precision)) {
                    return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(LogicalTypeAnnotation.decimalType(scale, precision))).named(name);
                }
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).as(LogicalTypeAnnotation.decimalType(scale, precision))).length(ParquetSchemaConverter.computeMinBytesForDecimalPrecision(precision))).named(name);
            }
            case TINYINT: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.INT_8)).named(name);
            }
            case SMALLINT: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.INT_16)).named(name);
            }
            case INTEGER: {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).named(name);
            }
            case BIGINT: {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).named(name);
            }
            case FLOAT: {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.FLOAT, repetition).named(name);
            }
            case DOUBLE: {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, repetition).named(name);
            }
            case DATE: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.DATE)).named(name);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.TIME_MILLIS)).named(name);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)type;
                return timestampType.getPrecision() <= 6 ? (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).named(name) : (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.INT96, repetition).named(name);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)type;
                return localZonedTimestampType.getPrecision() <= 6 ? (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).named(name) : (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.INT96, repetition).named(name);
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                return ConversionPatterns.listOfElements(repetition, name, ParquetSchemaConverter.convertToParquetType(LIST_ELEMENT_NAME, arrayType.getElementType()));
            }
            case MAP: {
                MapType mapType = (MapType)type;
                return ConversionPatterns.mapType(repetition, name, MAP_REPEATED_NAME, ParquetSchemaConverter.convertToParquetType("key", mapType.getKeyType()), ParquetSchemaConverter.convertToParquetType("value", mapType.getValueType()));
            }
            case MULTISET: {
                MultisetType multisetType = (MultisetType)type;
                return ConversionPatterns.mapType(repetition, name, MAP_REPEATED_NAME, ParquetSchemaConverter.convertToParquetType("key", multisetType.getElementType()), ParquetSchemaConverter.convertToParquetType("value", new IntType(false)));
            }
            case ROW: {
                RowType rowType = (RowType)type;
                return new GroupType(repetition, name, ParquetSchemaConverter.convertToParquetTypes(rowType));
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static List<Type> convertToParquetTypes(RowType rowType) {
        ArrayList<Type> types = new ArrayList<Type>(rowType.getFieldCount());
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            types.add(ParquetSchemaConverter.convertToParquetType(rowType.getFieldNames().get(i), rowType.getTypeAt(i)));
        }
        return types;
    }

    public static int computeMinBytesForDecimalPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }

    public static boolean is32BitDecimal(int precision) {
        return precision <= 9;
    }

    public static boolean is64BitDecimal(int precision) {
        return precision <= 18 && precision > 9;
    }
}

