/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.codegen;

import java.util.List;
import org.apache.paimon.codegen.CodeGenLoader;
import org.apache.paimon.codegen.GeneratedClass;
import org.apache.paimon.codegen.NormalizedKeyComputer;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.codegen.RecordComparator;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;

public class CodeGenUtils {
    public static final Projection EMPTY_PROJECTION = input -> BinaryRow.EMPTY_ROW;

    public static Projection newProjection(RowType inputType, List<String> fields) {
        List<String> fieldNames = inputType.getFieldNames();
        int[] mapping = fields.stream().mapToInt(fieldNames::indexOf).toArray();
        return CodeGenUtils.newProjection(inputType, mapping);
    }

    public static Projection newProjection(RowType inputType, int[] mapping) {
        if (mapping.length == 0) {
            return EMPTY_PROJECTION;
        }
        return CodeGenLoader.getCodeGenerator().generateProjection("Projection", inputType, mapping).newInstance(CodeGenUtils.class.getClassLoader());
    }

    public static NormalizedKeyComputer newNormalizedKeyComputer(List<DataType> fieldTypes, String name) {
        return CodeGenLoader.getCodeGenerator().generateNormalizedKeyComputer(fieldTypes, name).newInstance(CodeGenUtils.class.getClassLoader());
    }

    public static GeneratedClass<RecordComparator> generateRecordComparator(List<DataType> fieldTypes, String name) {
        return CodeGenLoader.getCodeGenerator().generateRecordComparator(fieldTypes, name);
    }

    public static GeneratedClass<RecordEqualiser> generateRecordEqualiser(List<DataType> fieldTypes, String name) {
        return CodeGenLoader.getCodeGenerator().generateRecordEqualiser(fieldTypes, name);
    }

    public static RecordComparator newRecordComparator(List<DataType> fieldTypes, String name) {
        return CodeGenUtils.generateRecordComparator(fieldTypes, name).newInstance(CodeGenUtils.class.getClassLoader());
    }
}

