/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.append;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.disk.RowBuffer;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.NewFilesIncrement;
import org.apache.paimon.io.RowDataRollingFileWriter;
import org.apache.paimon.memory.MemoryOwner;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.operation.metrics.WriterMetrics;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CommitIncrement;
import org.apache.paimon.utils.LongCounter;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RecordWriter;

public class AppendOnlyWriter
implements RecordWriter<InternalRow>,
MemoryOwner {
    private final FileIO fileIO;
    private final long schemaId;
    private final FileFormat fileFormat;
    private final long targetFileSize;
    private final RowType writeSchema;
    private final DataFilePathFactory pathFactory;
    private final CompactManager compactManager;
    private final boolean forceCompact;
    private final List<DataFileMeta> newFiles;
    private final List<DataFileMeta> compactBefore;
    private final List<DataFileMeta> compactAfter;
    private final LongCounter seqNumCounter;
    private final String fileCompression;
    private final SinkWriter sinkWriter;
    private final FieldStatsCollector.Factory[] statsCollectors;
    private final IOManager ioManager;
    private WriterMetrics writerMetrics;

    public AppendOnlyWriter(FileIO fileIO, IOManager ioManager, long schemaId, FileFormat fileFormat, long targetFileSize, RowType writeSchema, long maxSequenceNumber, CompactManager compactManager, boolean forceCompact, DataFilePathFactory pathFactory, @Nullable CommitIncrement increment, boolean useWriteBuffer, boolean spillable, String fileCompression, FieldStatsCollector.Factory[] statsCollectors, WriterMetrics writerMetrics) {
        this.fileIO = fileIO;
        this.schemaId = schemaId;
        this.fileFormat = fileFormat;
        this.targetFileSize = targetFileSize;
        this.writeSchema = writeSchema;
        this.pathFactory = pathFactory;
        this.compactManager = compactManager;
        this.forceCompact = forceCompact;
        this.newFiles = new ArrayList<DataFileMeta>();
        this.compactBefore = new ArrayList<DataFileMeta>();
        this.compactAfter = new ArrayList<DataFileMeta>();
        this.seqNumCounter = new LongCounter(maxSequenceNumber + 1L);
        this.fileCompression = fileCompression;
        this.ioManager = ioManager;
        this.statsCollectors = statsCollectors;
        SinkWriter sinkWriter = this.sinkWriter = useWriteBuffer ? new BufferedSinkWriter(spillable) : new DirectSinkWriter();
        if (increment != null) {
            this.newFiles.addAll(increment.newFilesIncrement().newFiles());
            this.compactBefore.addAll(increment.compactIncrement().compactBefore());
            this.compactAfter.addAll(increment.compactIncrement().compactAfter());
        }
        this.writerMetrics = writerMetrics;
    }

    @Override
    public void write(InternalRow rowData) throws Exception {
        Preconditions.checkArgument(rowData.getRowKind() == RowKind.INSERT, "Append-only writer can only accept insert row kind, but current row kind is: %s", new Object[]{rowData.getRowKind()});
        boolean success = this.sinkWriter.write(rowData);
        if (!success) {
            this.flush(false, false);
            success = this.sinkWriter.write(rowData);
            if (!success) {
                throw new RuntimeException("Mem table is too small to hold a single element.");
            }
        }
        if (this.writerMetrics != null) {
            this.writerMetrics.incWriteRecordNum();
        }
    }

    @Override
    public void compact(boolean fullCompaction) throws Exception {
        this.flush(true, fullCompaction);
    }

    @Override
    public void addNewFiles(List<DataFileMeta> files) {
        files.forEach(this.compactManager::addNewFile);
    }

    @Override
    public Collection<DataFileMeta> dataFiles() {
        return this.compactManager.allFiles();
    }

    @Override
    public CommitIncrement prepareCommit(boolean waitCompaction) throws Exception {
        long start = System.currentTimeMillis();
        this.flush(false, false);
        this.trySyncLatestCompaction(waitCompaction || this.forceCompact);
        CommitIncrement increment = this.drainIncrement();
        if (this.writerMetrics != null) {
            this.writerMetrics.updatePrepareCommitCostMillis(System.currentTimeMillis() - start);
        }
        return increment;
    }

    private void flush(boolean waitForLatestCompaction, boolean forcedFullCompaction) throws Exception {
        long start = System.currentTimeMillis();
        List<DataFileMeta> flushedFiles = this.sinkWriter.flush();
        flushedFiles.forEach(this.compactManager::addNewFile);
        this.trySyncLatestCompaction(waitForLatestCompaction);
        this.compactManager.triggerCompaction(forcedFullCompaction);
        this.newFiles.addAll(flushedFiles);
        if (this.writerMetrics != null) {
            this.writerMetrics.updateBufferFlushCostMillis(System.currentTimeMillis() - start);
        }
    }

    @Override
    public void sync() throws Exception {
        this.trySyncLatestCompaction(true);
    }

    @Override
    public void close() throws Exception {
        if (this.writerMetrics != null) {
            this.writerMetrics.close();
        }
        this.compactManager.cancelCompaction();
        this.sync();
        this.compactManager.close();
        for (DataFileMeta file : this.compactAfter) {
            this.fileIO.deleteQuietly(this.pathFactory.toPath(file.fileName()));
        }
        this.sinkWriter.close();
    }

    private RowDataRollingFileWriter createRollingRowWriter() {
        return new RowDataRollingFileWriter(this.fileIO, this.schemaId, this.fileFormat, this.targetFileSize, this.writeSchema, this.pathFactory, this.seqNumCounter, this.fileCompression, this.statsCollectors);
    }

    private void trySyncLatestCompaction(boolean blocking) throws ExecutionException, InterruptedException {
        this.compactManager.getCompactionResult(blocking).ifPresent(result -> {
            this.compactBefore.addAll(result.before());
            this.compactAfter.addAll(result.after());
        });
    }

    private CommitIncrement drainIncrement() {
        NewFilesIncrement newFilesIncrement = new NewFilesIncrement(new ArrayList<DataFileMeta>(this.newFiles), Collections.emptyList());
        CompactIncrement compactIncrement = new CompactIncrement(new ArrayList<DataFileMeta>(this.compactBefore), new ArrayList<DataFileMeta>(this.compactAfter), Collections.emptyList());
        this.newFiles.clear();
        this.compactBefore.clear();
        this.compactAfter.clear();
        return new CommitIncrement(newFilesIncrement, compactIncrement);
    }

    @Override
    public void setMemoryPool(MemorySegmentPool memoryPool) {
        this.sinkWriter.setMemoryPool(memoryPool);
    }

    @Override
    public long memoryOccupancy() {
        return this.sinkWriter.memoryOccupancy();
    }

    @Override
    public void flushMemory() throws Exception {
        this.flush(false, false);
    }

    @VisibleForTesting
    RowBuffer getWriteBuffer() {
        if (this.sinkWriter instanceof BufferedSinkWriter) {
            return ((BufferedSinkWriter)this.sinkWriter).writeBuffer;
        }
        return null;
    }

    @VisibleForTesting
    List<DataFileMeta> getNewFiles() {
        return this.newFiles;
    }

    private class BufferedSinkWriter
    implements SinkWriter {
        private final boolean spillable;
        private RowBuffer writeBuffer;

        private BufferedSinkWriter(boolean spillable) {
            this.spillable = spillable;
        }

        @Override
        public boolean write(InternalRow data) throws IOException {
            return this.writeBuffer.put(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<DataFileMeta> flush() throws IOException {
            ArrayList<DataFileMeta> flushedFiles = new ArrayList<DataFileMeta>();
            if (this.writeBuffer != null) {
                this.writeBuffer.complete();
                try (RowDataRollingFileWriter writer = AppendOnlyWriter.this.createRollingRowWriter();
                     RowBuffer.RowBufferIterator iterator = this.writeBuffer.newIterator();){
                    while (iterator.advanceNext()) {
                        writer.write(iterator.getRow());
                    }
                }
                flushedFiles.addAll((Collection<DataFileMeta>)writer.result());
                this.writeBuffer.reset();
            }
            return flushedFiles;
        }

        @Override
        public long memoryOccupancy() {
            return this.writeBuffer.memoryOccupancy();
        }

        @Override
        public void close() {
            if (this.writeBuffer != null) {
                this.writeBuffer.reset();
                this.writeBuffer = null;
            }
        }

        @Override
        public void setMemoryPool(MemorySegmentPool memoryPool) {
            this.writeBuffer = RowBuffer.getBuffer(AppendOnlyWriter.this.ioManager, memoryPool, new InternalRowSerializer(AppendOnlyWriter.this.writeSchema), this.spillable);
        }
    }

    private class DirectSinkWriter
    implements SinkWriter {
        private RowDataRollingFileWriter writer;

        private DirectSinkWriter() {
        }

        @Override
        public boolean write(InternalRow data) throws IOException {
            if (this.writer == null) {
                this.writer = AppendOnlyWriter.this.createRollingRowWriter();
            }
            this.writer.write(data);
            return true;
        }

        @Override
        public List<DataFileMeta> flush() throws IOException {
            ArrayList<DataFileMeta> flushedFiles = new ArrayList<DataFileMeta>();
            if (this.writer != null) {
                this.writer.close();
                flushedFiles.addAll((Collection<DataFileMeta>)this.writer.result());
                this.writer = null;
            }
            return flushedFiles;
        }

        @Override
        public long memoryOccupancy() {
            return 0L;
        }

        @Override
        public void close() {
            if (this.writer != null) {
                this.writer.abort();
                this.writer = null;
            }
        }

        @Override
        public void setMemoryPool(MemorySegmentPool memoryPool) {
        }
    }

    private static interface SinkWriter {
        public boolean write(InternalRow var1) throws IOException;

        public List<DataFileMeta> flush() throws IOException;

        public long memoryOccupancy();

        public void close();

        public void setMemoryPool(MemorySegmentPool var1);
    }
}

