/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import org.apache.paimon.KeyValue;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.JoinedRow;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.OffsetRow;

public class KeyValueSerializer
extends ObjectSerializer<KeyValue> {
    private static final long serialVersionUID = 1L;
    private final int keyArity;
    private final GenericRow reusedMeta;
    private final JoinedRow reusedKeyWithMeta;
    private final JoinedRow reusedRow;
    private final OffsetRow reusedKey;
    private final OffsetRow reusedValue;
    private final KeyValue reusedKv;

    public KeyValueSerializer(RowType keyType, RowType valueType) {
        super(KeyValue.schema(keyType, valueType));
        this.keyArity = keyType.getFieldCount();
        int valueArity = valueType.getFieldCount();
        this.reusedMeta = new GenericRow(2);
        this.reusedKeyWithMeta = new JoinedRow();
        this.reusedRow = new JoinedRow();
        this.reusedKey = new OffsetRow(this.keyArity, 0);
        this.reusedValue = new OffsetRow(valueArity, this.keyArity + 2);
        this.reusedKv = new KeyValue().replace(this.reusedKey, -1L, null, this.reusedValue);
    }

    @Override
    public InternalRow toRow(KeyValue record) {
        return this.toRow(record.key(), record.sequenceNumber(), record.valueKind(), record.value());
    }

    public InternalRow toRow(InternalRow key, long sequenceNumber, RowKind valueKind, InternalRow value) {
        this.reusedMeta.setField(0, sequenceNumber);
        this.reusedMeta.setField(1, valueKind.toByteValue());
        return this.reusedRow.replace(this.reusedKeyWithMeta.replace(key, this.reusedMeta), value);
    }

    @Override
    public KeyValue fromRow(InternalRow row) {
        this.reusedKey.replace(row);
        this.reusedValue.replace(row);
        long sequenceNumber = row.getLong(this.keyArity);
        RowKind valueKind = RowKind.fromByteValue(row.getByte(this.keyArity + 1));
        this.reusedKv.replace(this.reusedKey, sequenceNumber, valueKind, this.reusedValue);
        return this.reusedKv;
    }

    public KeyValue getReusedKv() {
        return this.reusedKv;
    }
}

