/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.paimon.Changelog;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.operation.SnapshotDeletion;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireSnapshotsImpl
implements ExpireSnapshots {
    private static final Logger LOG = LoggerFactory.getLogger(ExpireSnapshotsImpl.class);
    private final SnapshotManager snapshotManager;
    private final ConsumerManager consumerManager;
    private final SnapshotDeletion snapshotDeletion;
    private final TagManager tagManager;
    private ExpireConfig expireConfig;

    public ExpireSnapshotsImpl(SnapshotManager snapshotManager, SnapshotDeletion snapshotDeletion, TagManager tagManager) {
        this.snapshotManager = snapshotManager;
        this.consumerManager = new ConsumerManager(snapshotManager.fileIO(), snapshotManager.tablePath(), snapshotManager.branch());
        this.snapshotDeletion = snapshotDeletion;
        this.tagManager = tagManager;
        this.expireConfig = ExpireConfig.builder().build();
    }

    @Override
    public ExpireSnapshots config(ExpireConfig expireConfig) {
        this.expireConfig = expireConfig;
        return this;
    }

    @Override
    public int expire() {
        this.snapshotDeletion.setChangelogDecoupled(this.expireConfig.isChangelogDecoupled());
        int retainMax = this.expireConfig.getSnapshotRetainMax();
        int retainMin = this.expireConfig.getSnapshotRetainMin();
        int maxDeletes = this.expireConfig.getSnapshotMaxDeletes();
        long olderThanMills = System.currentTimeMillis() - this.expireConfig.getSnapshotTimeRetain().toMillis();
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            return 0;
        }
        Long earliest = this.snapshotManager.earliestSnapshotId();
        if (earliest == null) {
            return 0;
        }
        Preconditions.checkArgument(retainMax >= retainMin, "retainMax must greater than retainMin.");
        long min = Math.max(latestSnapshotId - (long)retainMax + 1L, earliest);
        long maxExclusive = latestSnapshotId - (long)retainMin + 1L;
        maxExclusive = Math.min(maxExclusive, this.consumerManager.minNextSnapshot().orElse(Long.MAX_VALUE));
        maxExclusive = Math.min(maxExclusive, earliest + (long)maxDeletes);
        for (long id = min; id < maxExclusive; ++id) {
            if (!this.snapshotManager.snapshotExists(id) || olderThanMills > this.snapshotManager.snapshot(id).timeMillis()) continue;
            return this.expireUntil(earliest, id);
        }
        return this.expireUntil(earliest, maxExclusive);
    }

    @VisibleForTesting
    public int expireUntil(long earliestId, long endExclusiveId) {
        Snapshot snapshot;
        long id;
        if (endExclusiveId <= earliestId) {
            if (this.snapshotManager.readHint("EARLIEST") == null) {
                this.writeEarliestHint(earliestId);
            }
            return 0;
        }
        long beginInclusiveId = earliestId;
        for (long id2 = endExclusiveId - 1L; id2 >= earliestId; --id2) {
            if (this.snapshotManager.snapshotExists(id2)) continue;
            beginInclusiveId = id2 + 1L;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Snapshot expire range is [" + beginInclusiveId + ", " + endExclusiveId + ")");
        }
        List<Snapshot> taggedSnapshots = this.tagManager.taggedSnapshots();
        for (id = beginInclusiveId + 1L; id <= endExclusiveId; ++id) {
            Predicate<ManifestEntry> skipper;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete merge tree files not used by snapshot #" + id);
            }
            snapshot = this.snapshotManager.snapshot(id);
            try {
                skipper = this.snapshotDeletion.createDataFileSkipperForTags(taggedSnapshots, id);
            }
            catch (Exception e) {
                LOG.info(String.format("Skip cleaning data files of snapshot '%s' due to failed to build skipping set.", id), (Throwable)e);
                continue;
            }
            this.snapshotDeletion.cleanUnusedDataFiles(snapshot, skipper);
        }
        if (!this.expireConfig.isChangelogDecoupled()) {
            for (id = beginInclusiveId; id < endExclusiveId; ++id) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ready to delete changelog files from snapshot #" + id);
                }
                if ((snapshot = this.snapshotManager.snapshot(id)).changelogManifestList() == null) continue;
                this.snapshotDeletion.deleteAddedDataFiles(snapshot.changelogManifestList());
            }
        }
        this.snapshotDeletion.cleanEmptyDirectories();
        List<Snapshot> skippingSnapshots = SnapshotManager.findOverlappedSnapshots(taggedSnapshots, beginInclusiveId, endExclusiveId);
        skippingSnapshots.add(this.snapshotManager.snapshot(endExclusiveId));
        Set<String> skippingSet = this.snapshotDeletion.manifestSkippingSet(skippingSnapshots);
        for (long id3 = beginInclusiveId; id3 < endExclusiveId; ++id3) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete manifests in snapshot #" + id3);
            }
            Snapshot snapshot2 = this.snapshotManager.snapshot(id3);
            this.snapshotDeletion.cleanUnusedManifests(snapshot2, skippingSet);
            if (this.expireConfig.isChangelogDecoupled()) {
                this.commitChangelog(new Changelog(snapshot2));
            }
            this.snapshotManager.fileIO().deleteQuietly(this.snapshotManager.snapshotPath(id3));
        }
        this.writeEarliestHint(endExclusiveId);
        return (int)(endExclusiveId - beginInclusiveId);
    }

    private void commitChangelog(Changelog changelog) {
        try {
            this.snapshotManager.commitChangelog(changelog, changelog.id());
            this.snapshotManager.commitLongLivedChangelogLatestHint(changelog.id());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeEarliestHint(long earliest) {
        try {
            this.snapshotManager.commitEarliestHint(earliest);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @VisibleForTesting
    public SnapshotDeletion snapshotDeletion() {
        return this.snapshotDeletion;
    }
}

