/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import javax.annotation.Nullable;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.casting.CastedRow;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ProjectedRow;

public class SimpleStatsConverter {
    private final InternalRowSerializer serializer;
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final CastFieldGetter[] castFieldGetters;

    public SimpleStatsConverter(RowType type) {
        this(type, null, null);
    }

    public SimpleStatsConverter(RowType type, @Nullable int[] indexMapping, @Nullable CastFieldGetter[] castFieldGetters) {
        RowType safeType = SimpleStatsConverter.toAllFieldsNullableRowType(type);
        this.serializer = new InternalRowSerializer(safeType);
        this.indexMapping = indexMapping;
        this.castFieldGetters = castFieldGetters;
    }

    public SimpleStats toBinary(SimpleColStats[] stats) {
        int rowFieldCount = stats.length;
        GenericRow minValues = new GenericRow(rowFieldCount);
        GenericRow maxValues = new GenericRow(rowFieldCount);
        Long[] nullCounts = new Long[rowFieldCount];
        for (int i = 0; i < rowFieldCount; ++i) {
            minValues.setField(i, stats[i].min());
            maxValues.setField(i, stats[i].max());
            nullCounts[i] = stats[i].nullCount();
        }
        return new SimpleStats(this.serializer.toBinaryRow(minValues).copy(), this.serializer.toBinaryRow(maxValues).copy(), BinaryArray.fromLongArray(nullCounts));
    }

    public InternalRow evolution(BinaryRow values) {
        InternalRow row = values;
        if (this.indexMapping != null) {
            row = ProjectedRow.from(this.indexMapping).replaceRow(row);
        }
        if (this.castFieldGetters != null) {
            row = CastedRow.from(this.castFieldGetters).replaceRow(values);
        }
        return row;
    }

    public InternalArray evolution(BinaryArray nullCounts, @Nullable Long rowCount) {
        if (this.indexMapping == null) {
            return nullCounts;
        }
        if (rowCount == null) {
            throw new RuntimeException("Schema Evolution for stats needs row count.");
        }
        return new NullCountsEvoArray(this.indexMapping, nullCounts, rowCount);
    }

    private static RowType toAllFieldsNullableRowType(RowType rowType) {
        return RowType.builder().fields((DataType[])rowType.getFields().stream().map(f -> f.type().copy(true)).toArray(DataType[]::new), rowType.getFieldNames().toArray(new String[0])).build();
    }

    private static class NullCountsEvoArray
    implements InternalArray {
        private final int[] indexMapping;
        private final InternalArray array;
        private final long notFoundValue;

        protected NullCountsEvoArray(int[] indexMapping, InternalArray array, long notFoundValue) {
            this.indexMapping = indexMapping;
            this.array = array;
            this.notFoundValue = notFoundValue;
        }

        @Override
        public int size() {
            return this.indexMapping.length;
        }

        @Override
        public boolean isNullAt(int pos) {
            if (this.indexMapping[pos] < 0) {
                return false;
            }
            return this.array.isNullAt(this.indexMapping[pos]);
        }

        @Override
        public long getLong(int pos) {
            if (this.indexMapping[pos] < 0) {
                return this.notFoundValue;
            }
            return this.array.getLong(this.indexMapping[pos]);
        }

        @Override
        public boolean getBoolean(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte getByte(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short getShort(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInt(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getFloat(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getDouble(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BinaryString getString(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Decimal getDecimal(int pos, int precision, int scale) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Timestamp getTimestamp(int pos, int precision) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getBinary(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InternalArray getArray(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InternalMap getMap(int pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InternalRow getRow(int pos, int numFields) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean[] toBooleanArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] toByteArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public short[] toShortArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int[] toIntArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long[] toLongArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] toFloatArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] toDoubleArray() {
            throw new UnsupportedOperationException();
        }
    }
}

