/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io.cache;

import java.io.RandomAccessFile;
import java.util.Objects;

public interface CacheKey {
    public static CacheKey forPosition(RandomAccessFile file, long position, int length) {
        return new PositionCacheKey(file, position, length);
    }

    public static CacheKey forPageIndex(RandomAccessFile file, int pageSize, int pageIndex) {
        return new PageIndexCacheKey(file, pageSize, pageIndex);
    }

    public static class PageIndexCacheKey
    implements CacheKey {
        private final RandomAccessFile file;
        private final int pageSize;
        private final int pageIndex;

        private PageIndexCacheKey(RandomAccessFile file, int pageSize, int pageIndex) {
            this.file = file;
            this.pageSize = pageSize;
            this.pageIndex = pageIndex;
        }

        public int pageIndex() {
            return this.pageIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageIndexCacheKey that = (PageIndexCacheKey)o;
            return this.pageSize == that.pageSize && this.pageIndex == that.pageIndex && Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.pageSize, this.pageIndex);
        }
    }

    public static class PositionCacheKey
    implements CacheKey {
        private final RandomAccessFile file;
        private final long position;
        private final int length;

        private PositionCacheKey(RandomAccessFile file, long position, int length) {
            this.file = file;
            this.position = position;
            this.length = length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PositionCacheKey that = (PositionCacheKey)o;
            return this.position == that.position && this.length == that.length && Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.position, this.length);
        }
    }
}

