/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.paimon.index.IndexFileMeta;

public class IndexIncrement {
    private final List<IndexFileMeta> newIndexFiles;
    private final List<IndexFileMeta> deletedIndexFiles;

    public IndexIncrement(List<IndexFileMeta> newIndexFiles) {
        this.newIndexFiles = newIndexFiles;
        this.deletedIndexFiles = Collections.emptyList();
    }

    public IndexIncrement(List<IndexFileMeta> newIndexFiles, List<IndexFileMeta> deletedIndexFiles) {
        this.newIndexFiles = newIndexFiles;
        this.deletedIndexFiles = deletedIndexFiles;
    }

    public List<IndexFileMeta> newIndexFiles() {
        return this.newIndexFiles;
    }

    public List<IndexFileMeta> deletedIndexFiles() {
        return this.deletedIndexFiles;
    }

    public boolean isEmpty() {
        return this.newIndexFiles.isEmpty() && this.deletedIndexFiles.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexIncrement that = (IndexIncrement)o;
        return Objects.equals(this.newIndexFiles, that.newIndexFiles) && Objects.equals(this.deletedIndexFiles, that.deletedIndexFiles);
    }

    public int hashCode() {
        ArrayList<IndexFileMeta> all = new ArrayList<IndexFileMeta>(this.newIndexFiles);
        all.addAll(this.deletedIndexFiles);
        return Objects.hash(all);
    }

    public String toString() {
        return "IndexIncrement{newIndexFiles=" + this.newIndexFiles + ",deletedIndexFiles=" + this.deletedIndexFiles + "}";
    }
}

