/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.metadata;

import java.util.Objects;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DecimalType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IcebergDataField {
    private static final String FIELD_ID = "id";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_REQUIRED = "required";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_DOC = "doc";
    @JsonProperty(value="id")
    private final int id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="required")
    private final boolean required;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="doc")
    private final String doc;

    public IcebergDataField(DataField dataField) {
        this(dataField.id(), dataField.name(), !dataField.type().isNullable(), IcebergDataField.toTypeString(dataField.type()), dataField.description());
    }

    @JsonCreator
    public IcebergDataField(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name, @JsonProperty(value="required") boolean required, @JsonProperty(value="type") String type, @JsonProperty(value="doc") String doc) {
        this.id = id;
        this.name = name;
        this.required = required;
        this.type = type;
        this.doc = doc;
    }

    @JsonGetter(value="id")
    public int id() {
        return this.id;
    }

    @JsonGetter(value="name")
    public String name() {
        return this.name;
    }

    @JsonGetter(value="required")
    public boolean required() {
        return this.required;
    }

    @JsonGetter(value="type")
    public String type() {
        return this.type;
    }

    @JsonGetter(value="doc")
    public String doc() {
        return this.doc;
    }

    private static String toTypeString(DataType dataType) {
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: {
                return "boolean";
            }
            case INTEGER: {
                return "int";
            }
            case BIGINT: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case DATE: {
                return "date";
            }
            case CHAR: 
            case VARCHAR: {
                return "string";
            }
            case BINARY: 
            case VARBINARY: {
                return "binary";
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)dataType;
                return String.format("decimal(%d, %d)", decimalType.getPrecision(), decimalType.getScale());
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + dataType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.required, this.type, this.doc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IcebergDataField)) {
            return false;
        }
        IcebergDataField that = (IcebergDataField)o;
        return this.id == that.id && Objects.equals(this.name, that.name) && this.required == that.required && Objects.equals(this.type, that.type) && Objects.equals(this.doc, that.doc);
    }
}

