/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.time.LocalDate;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.paimon.hive.objectinspector.WriteableObjectInspector;
import org.apache.paimon.utils.DateTimeUtils;

public class PaimonDateObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements DateObjectInspector,
WriteableObjectInspector {
    public PaimonDateObjectInspector() {
        super(TypeInfoFactory.dateTypeInfo);
    }

    public Date getPrimitiveJavaObject(Object o) {
        return o == null ? null : Date.ofEpochDay((int)((Integer)o));
    }

    public DateWritableV2 getPrimitiveWritableObject(Object o) {
        Date date = this.getPrimitiveJavaObject(o);
        return date == null ? null : new DateWritableV2(date);
    }

    public Object copyObject(Object o) {
        if (o instanceof Date) {
            Date date = (Date)o;
            return date.clone();
        }
        return o;
    }

    @Override
    public Integer convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return DateTimeUtils.toInternal(LocalDate.of(((Date)value).getYear(), ((Date)value).getMonth(), ((Date)value).getDay()));
        }
        return null;
    }
}

