/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SerBiFunction;

public class ProjectToRowFunction
implements SerBiFunction<InternalRow, BinaryRow, InternalRow> {
    private final InternalRow.FieldGetter[] fieldGetters;
    private final Map<Integer, Integer> projectMapping;
    private final InternalRow.FieldGetter[] projectGetters;

    public ProjectToRowFunction(RowType rowType, List<String> projectFields) {
        DataType[] types = rowType.getFieldTypes().toArray(new DataType[0]);
        this.fieldGetters = (InternalRow.FieldGetter[])IntStream.range(0, types.length).mapToObj(i -> InternalRow.createFieldGetter(types[i], i)).toArray(InternalRow.FieldGetter[]::new);
        List<String> fieldNames = rowType.getFieldNames();
        this.projectMapping = projectFields.stream().collect(Collectors.toMap(fieldNames::indexOf, projectFields::indexOf));
        this.projectGetters = (InternalRow.FieldGetter[])projectFields.stream().map(field -> InternalRow.createFieldGetter(types[rowType.getFieldIndex((String)field)], projectFields.indexOf(field))).toArray(InternalRow.FieldGetter[]::new);
    }

    @Override
    public InternalRow apply(InternalRow input, BinaryRow project) {
        GenericRow newRow = new GenericRow(this.fieldGetters.length);
        for (int i = 0; i < this.fieldGetters.length; ++i) {
            Object field = this.projectMapping.containsKey(i) ? this.projectGetters[this.projectMapping.get(i)].getFieldOrNull(project) : this.fieldGetters[i].getFieldOrNull(input);
            newRow.setField(i, field);
        }
        return newRow;
    }
}

