/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class IncrementalTagStartingScanner
extends AbstractStartingScanner {
    private final String start;
    private final String end;

    public IncrementalTagStartingScanner(SnapshotManager snapshotManager, String start, String end) {
        super(snapshotManager);
        this.start = start;
        this.end = end;
        TagManager tagManager = new TagManager(snapshotManager.fileIO(), snapshotManager.tablePath());
        Snapshot startingSnapshot = tagManager.taggedSnapshot(start);
        if (startingSnapshot != null) {
            this.startingSnapshotId = startingSnapshot.id();
        }
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader reader) {
        TagManager tagManager = new TagManager(this.snapshotManager.fileIO(), this.snapshotManager.tablePath());
        Snapshot tag1 = tagManager.taggedSnapshot(this.start);
        Snapshot tag2 = tagManager.taggedSnapshot(this.end);
        if (tag2.id() <= tag1.id()) {
            throw new IllegalArgumentException(String.format("Tag end %s with snapshot id %s should be larger than tag start %s with snapshot id %s", this.end, tag2.id(), this.start, tag1.id()));
        }
        return StartingScanner.fromPlan(reader.withSnapshot(tag2).readIncrementalDiff(tag1));
    }
}

