/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.paimon.Changelog;
import org.apache.paimon.Snapshot;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.operation.ChangelogDeletion;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireChangelogImpl
implements ExpireSnapshots {
    public static final Logger LOG = LoggerFactory.getLogger(ExpireChangelogImpl.class);
    private final SnapshotManager snapshotManager;
    private final ConsumerManager consumerManager;
    private final ChangelogDeletion changelogDeletion;
    private final TagManager tagManager;
    private ExpireConfig expireConfig;

    public ExpireChangelogImpl(SnapshotManager snapshotManager, TagManager tagManager, ChangelogDeletion changelogDeletion) {
        this.snapshotManager = snapshotManager;
        this.tagManager = tagManager;
        this.consumerManager = new ConsumerManager(snapshotManager.fileIO(), snapshotManager.tablePath(), snapshotManager.branch());
        this.changelogDeletion = changelogDeletion;
        this.expireConfig = ExpireConfig.builder().build();
    }

    @Override
    public ExpireSnapshots config(ExpireConfig expireConfig) {
        this.expireConfig = expireConfig;
        return this;
    }

    @Override
    public int expire() {
        int retainMax = this.expireConfig.getChangelogRetainMax();
        int retainMin = this.expireConfig.getChangelogRetainMin();
        int maxDeletes = this.expireConfig.getChangelogMaxDeletes();
        long olderThanMills = System.currentTimeMillis() - this.expireConfig.getChangelogTimeRetain().toMillis();
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            return 0;
        }
        Long earliestSnapshotId = this.snapshotManager.earliestSnapshotId();
        if (earliestSnapshotId == null) {
            return 0;
        }
        Long latestChangelogId = this.snapshotManager.latestLongLivedChangelogId();
        if (latestChangelogId == null) {
            return 0;
        }
        Long earliestChangelogId = this.snapshotManager.earliestLongLivedChangelogId();
        if (earliestChangelogId == null) {
            return 0;
        }
        Preconditions.checkArgument(retainMax >= retainMin, "retainMax must greater than retainMin.");
        long min = Math.max(latestSnapshotId - (long)retainMax + 1L, earliestChangelogId);
        long maxExclusive = latestSnapshotId - (long)retainMin + 1L;
        maxExclusive = Math.min(maxExclusive, this.consumerManager.minNextSnapshot().orElse(Long.MAX_VALUE));
        maxExclusive = Math.min(maxExclusive, earliestChangelogId + (long)maxDeletes);
        maxExclusive = Math.min(maxExclusive, latestChangelogId);
        for (long id = min; id <= maxExclusive; ++id) {
            if (!this.snapshotManager.longLivedChangelogExists(id) || olderThanMills > this.snapshotManager.longLivedChangelog(id).timeMillis()) continue;
            return this.expireUntil(earliestChangelogId, id);
        }
        return this.expireUntil(earliestChangelogId, maxExclusive);
    }

    public int expireUntil(long earliestId, long endExclusiveId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Changelog expire range is [" + earliestId + ", " + endExclusiveId + ")");
        }
        List<Snapshot> taggedSnapshots = this.tagManager.taggedSnapshots();
        List<Snapshot> skippingSnapshots = SnapshotManager.findOverlappedSnapshots(taggedSnapshots, earliestId, endExclusiveId);
        skippingSnapshots.add(this.snapshotManager.changelog(endExclusiveId));
        Set<String> manifestSkippSet = this.changelogDeletion.manifestSkippingSet(skippingSnapshots);
        for (long id = earliestId; id < endExclusiveId; ++id) {
            Predicate<ManifestEntry> skipper;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete changelog files from changelog #" + id);
            }
            Changelog changelog = this.snapshotManager.longLivedChangelog(id);
            try {
                skipper = this.changelogDeletion.createDataFileSkipperForTags(taggedSnapshots, id);
            }
            catch (Exception e) {
                LOG.info(String.format("Skip cleaning data files of changelog '%s' due to failed to build skipping set.", id), (Throwable)e);
                continue;
            }
            this.changelogDeletion.cleanUnusedDataFiles(changelog, skipper);
            this.changelogDeletion.cleanUnusedManifests(changelog, manifestSkippSet);
            this.snapshotManager.fileIO().deleteQuietly(this.snapshotManager.longLivedChangelogPath(id));
        }
        this.changelogDeletion.cleanEmptyDirectories();
        this.writeEarliestHintFile(endExclusiveId);
        return (int)(endExclusiveId - earliestId);
    }

    private void writeEarliestHintFile(long earliest) {
        try {
            this.snapshotManager.commitLongLivedChangelogEarliestHint(earliest);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

