/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition;

import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.partition.PartitionUpdateTimeExpireStrategy;
import org.apache.paimon.partition.PartitionValuesTimeExpireStrategy;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;

public abstract class PartitionExpireStrategy {
    protected final List<String> partitionKeys;
    private final RowDataToObjectArrayConverter toObjectArrayConverter;

    public PartitionExpireStrategy(RowType partitionType) {
        this.toObjectArrayConverter = new RowDataToObjectArrayConverter(partitionType);
        this.partitionKeys = partitionType.getFieldNames();
    }

    public Map<String, String> toPartitionString(Object[] array) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.partitionKeys.size(); ++i) {
            map.put(this.partitionKeys.get(i), array[i].toString());
        }
        return map;
    }

    public Object[] convertPartition(BinaryRow partition) {
        return this.toObjectArrayConverter.convert(partition);
    }

    public abstract List<PartitionEntry> selectExpiredPartitions(FileStoreScan var1, LocalDateTime var2);

    public static PartitionExpireStrategy createPartitionExpireStrategy(CoreOptions options, RowType partitionType) {
        switch (options.partitionExpireStrategy()) {
            case UPDATE_TIME: {
                return new PartitionUpdateTimeExpireStrategy(partitionType);
            }
        }
        return new PartitionValuesTimeExpireStrategy(options, partitionType);
    }
}

