/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.options;

import java.time.Duration;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.description.Description;
import org.apache.paimon.options.description.TextElement;
import org.apache.paimon.table.TableType;

public class CatalogOptions {
    public static final ConfigOption<String> WAREHOUSE = ConfigOptions.key("warehouse").stringType().noDefaultValue().withDescription("The warehouse root path of catalog.");
    public static final ConfigOption<String> METASTORE = ConfigOptions.key("metastore").stringType().defaultValue("filesystem").withDescription("Metastore of paimon catalog, supports filesystem, hive and jdbc.");
    public static final ConfigOption<String> URI = ConfigOptions.key("uri").stringType().noDefaultValue().withDescription("Uri of metastore server.");
    public static final ConfigOption<TableType> TABLE_TYPE = ConfigOptions.key("table.type").enumType(TableType.class).defaultValue(TableType.MANAGED).withDescription("Type of table.");
    public static final ConfigOption<Boolean> LOCK_ENABLED = ConfigOptions.key("lock.enabled").booleanType().noDefaultValue().withDescription("Enable Catalog Lock.");
    public static final ConfigOption<String> LOCK_TYPE = ConfigOptions.key("lock.type").stringType().noDefaultValue().withDescription("The Lock Type for Catalog, such as 'hive', 'zookeeper'.");
    public static final ConfigOption<Duration> LOCK_CHECK_MAX_SLEEP = ConfigOptions.key("lock-check-max-sleep").durationType().defaultValue(Duration.ofSeconds(8L)).withDescription("The maximum sleep time when retrying to check the lock.");
    public static final ConfigOption<Duration> LOCK_ACQUIRE_TIMEOUT = ConfigOptions.key("lock-acquire-timeout").durationType().defaultValue(Duration.ofMinutes(8L)).withDescription("The maximum time to wait for acquiring the lock.");
    public static final ConfigOption<Boolean> FS_ALLOW_HADOOP_FALLBACK = ConfigOptions.key("fs.allow-hadoop-fallback").booleanType().defaultValue(true).withDescription("Allow to fallback to hadoop File IO when no file io found for the scheme.");
    public static final ConfigOption<Integer> CLIENT_POOL_SIZE = ConfigOptions.key("client-pool-size").intType().defaultValue(2).withDescription("Configure the size of the connection pool.");
    public static final ConfigOption<Boolean> CACHE_ENABLED = ConfigOptions.key("cache-enabled").booleanType().defaultValue(true).withDescription("Controls whether the catalog will cache databases, tables and manifests.");
    public static final ConfigOption<Duration> CACHE_EXPIRATION_INTERVAL_MS = ConfigOptions.key("cache.expiration-interval").durationType().defaultValue(Duration.ofSeconds(60L)).withDescription("Controls the duration for which databases and tables in the catalog are cached.");
    public static final ConfigOption<MemorySize> CACHE_MANIFEST_SMALL_FILE_MEMORY = ConfigOptions.key("cache.manifest.small-file-memory").memoryType().defaultValue(MemorySize.ofMebiBytes(128L)).withDescription("Controls the cache memory to cache small manifest files.");
    public static final ConfigOption<MemorySize> CACHE_MANIFEST_SMALL_FILE_THRESHOLD = ConfigOptions.key("cache.manifest.small-file-threshold").memoryType().defaultValue(MemorySize.ofMebiBytes(1L)).withDescription("Controls the threshold of small manifest file.");
    public static final ConfigOption<MemorySize> CACHE_MANIFEST_MAX_MEMORY = ConfigOptions.key("cache.manifest.max-memory").memoryType().noDefaultValue().withDescription("Controls the maximum memory to cache manifest content.");
    public static final ConfigOption<String> LINEAGE_META = ConfigOptions.key("lineage-meta").stringType().noDefaultValue().withDescription(Description.builder().text("The lineage meta to store table and data lineage information.").linebreak().linebreak().text("Possible values:").linebreak().list(TextElement.text("\"jdbc\": Use standard jdbc to store table and data lineage information.")).list(TextElement.text("\"custom\": You can implement LineageMetaFactory and LineageMeta to store lineage information in customized storage.")).build());
    public static final ConfigOption<Boolean> ALLOW_UPPER_CASE = ConfigOptions.key("allow-upper-case").booleanType().noDefaultValue().withDescription("Indicates whether this catalog allow upper case, its default value depends on the implementation of the specific catalog.");
    public static final ConfigOption<Boolean> SYNC_ALL_PROPERTIES = ConfigOptions.key("sync-all-properties").booleanType().defaultValue(false).withDescription("Sync all table properties to hive metastore");
}

