/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.memory;

import org.apache.paimon.memory.MemorySegment;

public class BytesUtils {
    public static int getInt(byte[] bytes, int offset) {
        return bytes[offset + 3] << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
    }

    public static short getShort(byte[] bytes, int offset) {
        return (short)(bytes[offset + 1] << 8 | bytes[offset] & 0xFF);
    }

    public static long getLong(byte[] bytes, int offset) {
        return (long)bytes[offset + 7] << 56 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 1] & 0xFFL) << 8 | (long)bytes[offset] & 0xFFL;
    }

    public static byte[] readBinary(byte[] bytes, int baseOffset, int fieldOffset, long variablePartOffsetAndLen) {
        long mark = variablePartOffsetAndLen & Long.MIN_VALUE;
        if (mark == 0L) {
            int subOffset = (int)(variablePartOffsetAndLen >> 32);
            int len = (int)variablePartOffsetAndLen;
            byte[] ret = new byte[len];
            System.arraycopy(bytes, baseOffset + subOffset, ret, 0, len);
            return ret;
        }
        int len = (int)((variablePartOffsetAndLen & 0x7F00000000000000L) >>> 56);
        byte[] ret = new byte[len];
        if (MemorySegment.LITTLE_ENDIAN) {
            System.arraycopy(bytes, fieldOffset, ret, 0, len);
        } else {
            System.arraycopy(bytes, fieldOffset + 1, ret, 0, len);
        }
        return ret;
    }
}

