/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.ApplyDeletionVectorReader;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatKey;
import org.apache.paimon.format.FormatReaderContext;
import org.apache.paimon.format.OrcFormatReaderContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.FileReaderFactory;
import org.apache.paimon.io.FileRecordReader;
import org.apache.paimon.io.KeyValueDataFileRecordReader;
import org.apache.paimon.partition.PartitionUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.IndexCastMapping;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaEvolutionUtil;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.AsyncRecordReader;
import org.apache.paimon.utils.BulkFormatMapping;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Projection;

public class KeyValueFileReaderFactory
implements FileReaderFactory<KeyValue> {
    private final FileIO fileIO;
    private final SchemaManager schemaManager;
    private final TableSchema schema;
    private final RowType keyType;
    private final RowType valueType;
    private final BulkFormatMappingBuilder bulkFormatMappingBuilder;
    private final DataFilePathFactory pathFactory;
    private final long asyncThreshold;
    private final Map<FormatKey, BulkFormatMapping> bulkFormatMappings;
    private final BinaryRow partition;
    private final DeletionVector.Factory dvFactory;

    private KeyValueFileReaderFactory(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, RowType keyType, RowType valueType, BulkFormatMappingBuilder bulkFormatMappingBuilder, DataFilePathFactory pathFactory, long asyncThreshold, BinaryRow partition, DeletionVector.Factory dvFactory) {
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.schema = schema;
        this.keyType = keyType;
        this.valueType = valueType;
        this.bulkFormatMappingBuilder = bulkFormatMappingBuilder;
        this.pathFactory = pathFactory;
        this.asyncThreshold = asyncThreshold;
        this.partition = partition;
        this.bulkFormatMappings = new HashMap<FormatKey, BulkFormatMapping>();
        this.dvFactory = dvFactory;
    }

    @Override
    public RecordReader<KeyValue> createRecordReader(DataFileMeta file) throws IOException {
        return this.createRecordReader(file.schemaId(), file.fileName(), file.fileSize(), file.level());
    }

    public RecordReader<KeyValue> createRecordReader(long schemaId, String fileName, long fileSize, int level) throws IOException {
        if (fileSize >= this.asyncThreshold && fileName.endsWith(".orc")) {
            return new AsyncRecordReader<KeyValue>(() -> this.createRecordReader(schemaId, fileName, level, false, 2, fileSize));
        }
        return this.createRecordReader(schemaId, fileName, level, true, null, fileSize);
    }

    private RecordReader<KeyValue> createRecordReader(long schemaId, String fileName, int level, boolean reuseFormat, @Nullable Integer orcPoolSize, long fileSize) throws IOException {
        String formatIdentifier = DataFilePathFactory.formatIdentifier(fileName);
        Supplier<BulkFormatMapping> formatSupplier = () -> this.bulkFormatMappingBuilder.build(formatIdentifier, this.schema, schemaId == this.schema.id() ? this.schema : this.schemaManager.schema(schemaId));
        BulkFormatMapping bulkFormatMapping = reuseFormat ? this.bulkFormatMappings.computeIfAbsent(new FormatKey(schemaId, formatIdentifier), key -> (BulkFormatMapping)formatSupplier.get()) : formatSupplier.get();
        Path filePath = this.pathFactory.toPath(fileName);
        RecordReader<InternalRow> fileRecordReader = new FileRecordReader(bulkFormatMapping.getReaderFactory(), orcPoolSize == null ? new FormatReaderContext(this.fileIO, filePath, fileSize) : new OrcFormatReaderContext(this.fileIO, filePath, fileSize, orcPoolSize), bulkFormatMapping.getIndexMapping(), bulkFormatMapping.getCastMapping(), PartitionUtils.create(bulkFormatMapping.getPartitionPair(), this.partition));
        Optional<DeletionVector> deletionVector = this.dvFactory.create(fileName);
        if (deletionVector.isPresent() && !deletionVector.get().isEmpty()) {
            fileRecordReader = new ApplyDeletionVectorReader(fileRecordReader, deletionVector.get());
        }
        return new KeyValueDataFileRecordReader(fileRecordReader, this.keyType, this.valueType, level);
    }

    public static Builder builder(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, RowType keyType, RowType valueType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory, KeyValueFieldsExtractor extractor, CoreOptions options) {
        return new Builder(fileIO, schemaManager, schema, keyType, valueType, formatDiscover, pathFactory, extractor, options);
    }

    private static class BulkFormatMappingBuilder {
        private final FileFormatDiscover formatDiscover;
        private final KeyValueFieldsExtractor extractor;
        private final int[][] keyProjection;
        private final int[][] valueProjection;
        @Nullable
        private final List<Predicate> filters;

        private BulkFormatMappingBuilder(FileFormatDiscover formatDiscover, KeyValueFieldsExtractor extractor, int[][] keyProjection, int[][] valueProjection, @Nullable List<Predicate> filters) {
            this.formatDiscover = formatDiscover;
            this.extractor = extractor;
            this.keyProjection = keyProjection;
            this.valueProjection = valueProjection;
            this.filters = filters;
        }

        public BulkFormatMapping build(String formatIdentifier, TableSchema tableSchema, TableSchema dataSchema) {
            Pair<int[], int[][]> partitionMapping;
            List<DataField> tableKeyFields = this.extractor.keyFields(tableSchema);
            List<DataField> tableValueFields = this.extractor.valueFields(tableSchema);
            int[][] tableProjection = KeyValue.project(this.keyProjection, this.valueProjection, tableKeyFields.size());
            List<DataField> dataKeyFields = this.extractor.keyFields(dataSchema);
            List<DataField> dataValueFields = this.extractor.valueFields(dataSchema);
            RowType keyType = new RowType(dataKeyFields);
            RowType valueType = new RowType(dataValueFields);
            RowType dataRecordType = KeyValue.schema(keyType, valueType);
            int[][] dataKeyProjection = SchemaEvolutionUtil.createDataProjection(tableKeyFields, dataKeyFields, this.keyProjection);
            int[][] dataValueProjection = SchemaEvolutionUtil.createDataProjection(tableValueFields, dataValueFields, this.valueProjection);
            int[][] dataProjection = KeyValue.project(dataKeyProjection, dataValueProjection, dataKeyFields.size());
            IndexCastMapping indexCastMapping = SchemaEvolutionUtil.createIndexCastMapping(Projection.of(tableProjection).toTopLevelIndexes(), tableKeyFields, tableValueFields, Projection.of(dataProjection).toTopLevelIndexes(), dataKeyFields, dataValueFields);
            List<Predicate> dataFilters = tableSchema.id() == dataSchema.id() ? this.filters : SchemaEvolutionUtil.createDataFilters(tableSchema.fields(), dataSchema.fields(), this.filters);
            List<Predicate> nonPartitionFilters = PredicateBuilder.excludePredicateWithFields(dataFilters, new HashSet<String>(dataSchema.partitionKeys()));
            Pair<int[], RowType> partitionPair = null;
            if (!dataSchema.partitionKeys().isEmpty() && (partitionMapping = PartitionUtils.constructPartitionMapping(dataRecordType, dataSchema.partitionKeys(), dataProjection)) != null) {
                dataProjection = partitionMapping.getRight();
                partitionPair = Pair.of(partitionMapping.getLeft(), dataSchema.projectedLogicalRowType(dataSchema.partitionKeys()));
            }
            RowType projectedRowType = Projection.of(dataProjection).project(dataRecordType);
            return new BulkFormatMapping(indexCastMapping.getIndexMapping(), indexCastMapping.getCastMapping(), partitionPair, this.formatDiscover.discover(formatIdentifier).createReaderFactory(projectedRowType, nonPartitionFilters));
        }
    }

    public static class Builder {
        private final FileIO fileIO;
        private final SchemaManager schemaManager;
        private final TableSchema schema;
        private final RowType keyType;
        private final RowType valueType;
        private final FileFormatDiscover formatDiscover;
        private final FileStorePathFactory pathFactory;
        private final KeyValueFieldsExtractor extractor;
        private final int[][] fullKeyProjection;
        private final CoreOptions options;
        private int[][] keyProjection;
        private int[][] valueProjection;
        private RowType projectedKeyType;
        private RowType projectedValueType;

        private Builder(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, RowType keyType, RowType valueType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory, KeyValueFieldsExtractor extractor, CoreOptions options) {
            this.fileIO = fileIO;
            this.schemaManager = schemaManager;
            this.schema = schema;
            this.keyType = keyType;
            this.valueType = valueType;
            this.formatDiscover = formatDiscover;
            this.pathFactory = pathFactory;
            this.extractor = extractor;
            this.fullKeyProjection = Projection.range(0, keyType.getFieldCount()).toNestedIndexes();
            this.options = options;
            this.keyProjection = this.fullKeyProjection;
            this.valueProjection = Projection.range(0, valueType.getFieldCount()).toNestedIndexes();
            this.applyProjection();
        }

        public Builder copyWithoutProjection() {
            return new Builder(this.fileIO, this.schemaManager, this.schema, this.keyType, this.valueType, this.formatDiscover, this.pathFactory, this.extractor, this.options);
        }

        public Builder withKeyProjection(int[][] projection) {
            this.keyProjection = projection;
            this.applyProjection();
            return this;
        }

        public Builder withValueProjection(int[][] projection) {
            this.valueProjection = projection;
            this.applyProjection();
            return this;
        }

        public RowType keyType() {
            return this.keyType;
        }

        public RowType projectedValueType() {
            return this.projectedValueType;
        }

        public KeyValueFileReaderFactory build(BinaryRow partition, int bucket, DeletionVector.Factory dvFactory) {
            return this.build(partition, bucket, dvFactory, true, Collections.emptyList());
        }

        public KeyValueFileReaderFactory build(BinaryRow partition, int bucket, DeletionVector.Factory dvFactory, boolean projectKeys, @Nullable List<Predicate> filters) {
            int[][] keyProjection = projectKeys ? this.keyProjection : this.fullKeyProjection;
            RowType projectedKeyType = projectKeys ? this.projectedKeyType : this.keyType;
            return new KeyValueFileReaderFactory(this.fileIO, this.schemaManager, this.schema, projectedKeyType, this.projectedValueType, new BulkFormatMappingBuilder(this.formatDiscover, this.extractor, keyProjection, this.valueProjection, filters), this.pathFactory.createDataFilePathFactory(partition, bucket), this.options.fileReaderAsyncThreshold().getBytes(), partition, dvFactory);
        }

        private void applyProjection() {
            this.projectedKeyType = Projection.of(this.keyProjection).project(this.keyType);
            this.projectedValueType = Projection.of(this.valueProjection).project(this.valueType);
        }

        public FileIO fileIO() {
            return this.fileIO;
        }
    }
}

