/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.SerializationUtils;

public class DataFileMetaSerializer
extends ObjectSerializer<DataFileMeta> {
    private static final long serialVersionUID = 1L;

    public DataFileMetaSerializer() {
        super(DataFileMeta.SCHEMA);
    }

    @Override
    public InternalRow toRow(DataFileMeta meta) {
        return GenericRow.of(BinaryString.fromString(meta.fileName()), meta.fileSize(), meta.rowCount(), SerializationUtils.serializeBinaryRow(meta.minKey()), SerializationUtils.serializeBinaryRow(meta.maxKey()), meta.keyStats().toRow(), meta.valueStats().toRow(), meta.minSequenceNumber(), meta.maxSequenceNumber(), meta.schemaId(), meta.level(), InternalRowUtils.toStringArrayData(meta.extraFiles()), meta.creationTime(), meta.deleteRowCount().orElse(null), meta.embeddedIndex(), meta.fileSource().map(FileSource::toByteValue).orElse(null));
    }

    @Override
    public DataFileMeta fromRow(InternalRow row) {
        return new DataFileMeta(row.getString(0).toString(), row.getLong(1), row.getLong(2), SerializationUtils.deserializeBinaryRow(row.getBinary(3)), SerializationUtils.deserializeBinaryRow(row.getBinary(4)), SimpleStats.fromRow(row.getRow(5, 3)), SimpleStats.fromRow(row.getRow(6, 3)), row.getLong(7), row.getLong(8), row.getLong(9), row.getInt(10), InternalRowUtils.fromStringArrayData(row.getArray(11)), row.getTimestamp(12, 3), row.isNullAt(13) ? null : Long.valueOf(row.getLong(13)), row.isNullAt(14) ? null : row.getBinary(14), row.isNullAt(15) ? null : FileSource.fromByteValue(row.getByte(15)));
    }
}

