/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import org.apache.paimon.format.parquet.position.CollectionPosition;
import org.apache.paimon.format.parquet.type.ParquetField;
import org.apache.paimon.utils.BooleanArrayList;
import org.apache.paimon.utils.LongArrayList;

public class NestedPositionUtil {
    public static CollectionPosition calculateCollectionOffsets(ParquetField field, int[] definitionLevels, int[] repetitionLevels, boolean readRowField) {
        int collectionDefinitionLevel = field.getDefinitionLevel();
        int collectionRepetitionLevel = field.getRepetitionLevel() + 1;
        int offset = 0;
        int valueCount = 0;
        LongArrayList offsets = new LongArrayList(0);
        offsets.add(offset);
        BooleanArrayList emptyCollectionFlags = new BooleanArrayList(0);
        BooleanArrayList nullCollectionFlags = new BooleanArrayList(0);
        int nullValuesCount = 0;
        int i = 0;
        while (i < definitionLevels.length) {
            if (definitionLevels[i] >= collectionDefinitionLevel - 1) {
                if (definitionLevels[i] > collectionDefinitionLevel) {
                    nullCollectionFlags.add(false);
                    emptyCollectionFlags.add(false);
                    offset += NestedPositionUtil.getCollectionSize(repetitionLevels, collectionRepetitionLevel, i + 1);
                } else if (definitionLevels[i] == collectionDefinitionLevel) {
                    nullCollectionFlags.add(false);
                    emptyCollectionFlags.add(true);
                } else {
                    nullCollectionFlags.add(true);
                    ++nullValuesCount;
                    emptyCollectionFlags.add(false);
                }
                offsets.add(offset);
                ++valueCount;
            } else if (definitionLevels[i] == collectionDefinitionLevel - 2 && readRowField) {
                nullCollectionFlags.add(true);
                ++nullValuesCount;
                emptyCollectionFlags.add(false);
                offsets.add(offset);
                ++valueCount;
            }
            i = NestedPositionUtil.getNextCollectionStartIndex(repetitionLevels, collectionRepetitionLevel, i);
        }
        long[] offsetsArray = offsets.toArray();
        long[] length = NestedPositionUtil.calculateLengthByOffsets(emptyCollectionFlags.toArray(), offsetsArray);
        if (nullValuesCount == 0) {
            return new CollectionPosition(null, offsetsArray, length, valueCount);
        }
        return new CollectionPosition(nullCollectionFlags.toArray(), offsetsArray, length, valueCount);
    }

    public static long[] calculateLengthByOffsets(boolean[] collectionIsEmpty, long[] arrayOffsets) {
        LongArrayList lengthList = new LongArrayList(arrayOffsets.length);
        for (int i = 0; i < arrayOffsets.length - 1; ++i) {
            long offset = arrayOffsets[i];
            long length = arrayOffsets[i + 1] - offset;
            if (length < 0L) {
                throw new IllegalArgumentException(String.format("Offset is not monotonically ascending. offsets[%s]=%s, offsets[%s]=%s", i, arrayOffsets[i], i + 1, arrayOffsets[i + 1]));
            }
            if (collectionIsEmpty[i]) {
                length = 0L;
            }
            lengthList.add(length);
        }
        return lengthList.toArray();
    }

    private static int getNextCollectionStartIndex(int[] repetitionLevels, int maxRepetitionLevel, int elementIndex) {
        while (NestedPositionUtil.hasMoreElements(repetitionLevels, ++elementIndex) && NestedPositionUtil.isNotCollectionBeginningMarker(repetitionLevels, maxRepetitionLevel, elementIndex)) {
        }
        return elementIndex;
    }

    private static int getCollectionSize(int[] repetitionLevels, int maxRepetitionLevel, int nextIndex) {
        int size = 1;
        while (NestedPositionUtil.hasMoreElements(repetitionLevels, nextIndex) && NestedPositionUtil.isNotCollectionBeginningMarker(repetitionLevels, maxRepetitionLevel, nextIndex)) {
            if (repetitionLevels[nextIndex] <= maxRepetitionLevel) {
                ++size;
            }
            ++nextIndex;
        }
        return size;
    }

    private static boolean isNotCollectionBeginningMarker(int[] repetitionLevels, int maxRepetitionLevel, int nextIndex) {
        return repetitionLevels[nextIndex] >= maxRepetitionLevel;
    }

    private static boolean hasMoreElements(int[] repetitionLevels, int nextIndex) {
        return nextIndex < repetitionLevels.length;
    }
}

