/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypeVisitor;

@Public
public final class TimeType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final int MIN_PRECISION = 0;
    public static final int MAX_PRECISION = 9;
    public static final int DEFAULT_PRECISION = 0;
    private static final String FORMAT = "TIME(%d)";
    private final int precision;

    public TimeType(boolean isNullable, int precision) {
        super(isNullable, DataTypeRoot.TIME_WITHOUT_TIME_ZONE);
        if (precision < 0 || precision > 9) {
            throw new IllegalArgumentException(String.format("Time precision must be between %d and %d (both inclusive).", 0, 9));
        }
        this.precision = precision;
    }

    public TimeType(int precision) {
        this(true, precision);
    }

    public TimeType() {
        this(0);
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new TimeType(isNullable, this.precision);
    }

    @Override
    public String asSQLString() {
        return this.withNullability(FORMAT, this.precision);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeType timeType = (TimeType)o;
        return this.precision == timeType.precision;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision);
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

