/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import org.apache.paimon.annotation.Public;

@Public
public enum RowKind {
    INSERT("+I", 0),
    UPDATE_BEFORE("-U", 1),
    UPDATE_AFTER("+U", 2),
    DELETE("-D", 3);

    private final String shortString;
    private final byte value;

    private RowKind(String shortString, byte value) {
        this.shortString = shortString;
        this.value = value;
    }

    public String shortString() {
        return this.shortString;
    }

    public byte toByteValue() {
        return this.value;
    }

    public boolean isRetract() {
        return this == UPDATE_BEFORE || this == DELETE;
    }

    public boolean isAdd() {
        return this == INSERT || this == UPDATE_AFTER;
    }

    public static RowKind fromByteValue(byte value) {
        switch (value) {
            case 0: {
                return INSERT;
            }
            case 1: {
                return UPDATE_BEFORE;
            }
            case 2: {
                return UPDATE_AFTER;
            }
            case 3: {
                return DELETE;
            }
        }
        throw new UnsupportedOperationException("Unsupported byte value '" + value + "' for row kind.");
    }

    public static RowKind fromShortString(String value) {
        switch (value.toUpperCase()) {
            case "+I": {
                return INSERT;
            }
            case "-U": {
                return UPDATE_BEFORE;
            }
            case "+U": {
                return UPDATE_AFTER;
            }
            case "-D": {
                return DELETE;
            }
        }
        throw new UnsupportedOperationException("Unsupported short string '" + value + "' for row kind.");
    }
}

