/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingContext;

public interface StartingScanner {
    public StartingContext startingContext();

    public Result scan(SnapshotReader var1);

    public static ScannedResult fromPlan(SnapshotReader.Plan plan) {
        return new ScannedResult(plan);
    }

    public static class NextSnapshot
    implements Result {
        private final long nextSnapshotId;

        public NextSnapshot(long nextSnapshotId) {
            this.nextSnapshotId = nextSnapshotId;
        }

        public long nextSnapshotId() {
            return this.nextSnapshotId;
        }
    }

    public static class ScannedResult
    implements Result {
        private final SnapshotReader.Plan plan;

        public ScannedResult(SnapshotReader.Plan plan) {
            this.plan = plan;
        }

        public long currentSnapshotId() {
            return this.plan.snapshotId();
        }

        @Nullable
        public Long currentWatermark() {
            return this.plan.watermark();
        }

        public List<DataSplit> splits() {
            return this.plan.splits();
        }

        public SnapshotReader.Plan plan() {
            return this.plan;
        }
    }

    public static class NoSnapshot
    implements Result {
    }

    public static interface Result {
    }
}

