/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.compact.CompactUnit;
import org.apache.paimon.mergetree.LevelSortedRun;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.CompactStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalCompaction
implements CompactStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(UniversalCompaction.class);
    private final int maxSizeAmp;
    private final int sizeRatio;
    private final int numRunCompactionTrigger;
    @Nullable
    private final Long opCompactionInterval;
    @Nullable
    private Long lastOptimizedCompaction;

    public UniversalCompaction(int maxSizeAmp, int sizeRatio, int numRunCompactionTrigger) {
        this(maxSizeAmp, sizeRatio, numRunCompactionTrigger, null);
    }

    public UniversalCompaction(int maxSizeAmp, int sizeRatio, int numRunCompactionTrigger, @Nullable Duration opCompactionInterval) {
        this.maxSizeAmp = maxSizeAmp;
        this.sizeRatio = sizeRatio;
        this.numRunCompactionTrigger = numRunCompactionTrigger;
        this.opCompactionInterval = opCompactionInterval == null ? null : Long.valueOf(opCompactionInterval.toMillis());
    }

    @Override
    public Optional<CompactUnit> pick(int numLevels, List<LevelSortedRun> runs) {
        int maxLevel = numLevels - 1;
        if (this.opCompactionInterval != null && (this.lastOptimizedCompaction == null || this.currentTimeMillis() - this.lastOptimizedCompaction > this.opCompactionInterval)) {
            LOG.debug("Universal compaction due to optimized compaction interval");
            this.updateLastOptimizedCompaction();
            return Optional.of(CompactUnit.fromLevelRuns(maxLevel, runs));
        }
        CompactUnit unit = this.pickForSizeAmp(maxLevel, runs);
        if (unit != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Universal compaction due to size amplification");
            }
            return Optional.of(unit);
        }
        unit = this.pickForSizeRatio(maxLevel, runs);
        if (unit != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Universal compaction due to size ratio");
            }
            return Optional.of(unit);
        }
        if (runs.size() > this.numRunCompactionTrigger) {
            int candidateCount = runs.size() - this.numRunCompactionTrigger + 1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Universal compaction due to file num");
            }
            return Optional.ofNullable(this.pickForSizeRatio(maxLevel, runs, candidateCount));
        }
        return Optional.empty();
    }

    @VisibleForTesting
    CompactUnit pickForSizeAmp(int maxLevel, List<LevelSortedRun> runs) {
        long earliestRunSize;
        if (runs.size() < this.numRunCompactionTrigger) {
            return null;
        }
        long candidateSize = runs.subList(0, runs.size() - 1).stream().map(LevelSortedRun::run).mapToLong(SortedRun::totalSize).sum();
        if (candidateSize * 100L > (long)this.maxSizeAmp * (earliestRunSize = runs.get(runs.size() - 1).run().totalSize())) {
            this.updateLastOptimizedCompaction();
            return CompactUnit.fromLevelRuns(maxLevel, runs);
        }
        return null;
    }

    @VisibleForTesting
    CompactUnit pickForSizeRatio(int maxLevel, List<LevelSortedRun> runs) {
        if (runs.size() < this.numRunCompactionTrigger) {
            return null;
        }
        return this.pickForSizeRatio(maxLevel, runs, 1);
    }

    private CompactUnit pickForSizeRatio(int maxLevel, List<LevelSortedRun> runs, int candidateCount) {
        return this.pickForSizeRatio(maxLevel, runs, candidateCount, false);
    }

    public CompactUnit pickForSizeRatio(int maxLevel, List<LevelSortedRun> runs, int candidateCount, boolean forcePick) {
        LevelSortedRun next;
        long candidateSize = this.candidateSize(runs, candidateCount);
        for (int i = candidateCount; i < runs.size() && !((double)candidateSize * (100.0 + (double)this.sizeRatio) / 100.0 < (double)(next = runs.get(i)).run().totalSize()); ++i) {
            candidateSize += next.run().totalSize();
            ++candidateCount;
        }
        if (forcePick || candidateCount > 1) {
            return this.createUnit(runs, maxLevel, candidateCount);
        }
        return null;
    }

    private long candidateSize(List<LevelSortedRun> runs, int candidateCount) {
        long size = 0L;
        for (int i = 0; i < candidateCount; ++i) {
            size += runs.get(i).run().totalSize();
        }
        return size;
    }

    @VisibleForTesting
    CompactUnit createUnit(List<LevelSortedRun> runs, int maxLevel, int runCount) {
        int outputLevel = runCount == runs.size() ? maxLevel : Math.max(0, runs.get(runCount).level() - 1);
        if (outputLevel == 0) {
            for (int i = runCount; i < runs.size(); ++i) {
                LevelSortedRun next = runs.get(i);
                ++runCount;
                if (next.level() == 0) continue;
                outputLevel = next.level();
                break;
            }
        }
        if (runCount == runs.size()) {
            this.updateLastOptimizedCompaction();
            outputLevel = maxLevel;
        }
        return CompactUnit.fromLevelRuns(outputLevel, runs.subList(0, runCount));
    }

    private void updateLastOptimizedCompaction() {
        this.lastOptimizedCompaction = this.currentTimeMillis();
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

