/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.paimon.client.ClientPool;
import org.apache.paimon.jdbc.JdbcUtils;

public class JdbcClientPool
extends ClientPool.ClientPoolImpl<Connection, SQLException> {
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("jdbc:([^:]+):(.*)");
    private final String dbUrl;
    private final Map<String, String> properties;
    private final String protocol;

    public JdbcClientPool(int poolSize, String dbUrl, Map<String, String> props) {
        super(poolSize, SQLNonTransientConnectionException.class, true);
        this.properties = props;
        this.dbUrl = dbUrl;
        Matcher matcher = PROTOCOL_PATTERN.matcher(dbUrl);
        if (!matcher.matches()) {
            throw new RuntimeException("Invalid Jdbc url: " + dbUrl);
        }
        this.protocol = matcher.group(1);
    }

    @Override
    protected Connection newClient() {
        try {
            Properties dbProps = JdbcUtils.extractJdbcConfiguration(this.properties, "jdbc.");
            return DriverManager.getConnection(this.dbUrl, dbProps);
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to connect: %s", this.dbUrl), e);
        }
    }

    @Override
    protected Connection reconnect(Connection client) {
        this.close(client);
        return this.newClient();
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    protected void close(Connection client) {
        try {
            client.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to close connection", e);
        }
    }
}

