/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.compression.BlockCompressor;
import org.apache.paimon.io.PageFileOutput;

public class CompressedPageFileOutput
implements PageFileOutput {
    private final FileOutputStream out;
    private final byte[] page;
    private final BlockCompressor compressor;
    private final byte[] compressedPage;
    private final List<Long> pages;
    private long uncompressBytes;
    private long position;
    private int count;

    public CompressedPageFileOutput(File file, int pageSize, BlockCompressionFactory compressionFactory) throws FileNotFoundException {
        this.out = new FileOutputStream(file);
        this.page = new byte[pageSize];
        this.compressor = compressionFactory.getCompressor();
        this.compressedPage = new byte[this.compressor.getMaxCompressedSize(pageSize)];
        this.pages = new ArrayList<Long>();
        this.uncompressBytes = 0L;
        this.position = 0L;
        this.count = 0;
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.pages.add(this.position);
            int len = this.compressor.compress(this.page, 0, this.count, this.compressedPage, 0);
            this.out.write(len >>> 24 & 0xFF);
            this.out.write(len >>> 16 & 0xFF);
            this.out.write(len >>> 8 & 0xFF);
            this.out.write(len & 0xFF);
            this.out.write(this.compressedPage, 0, len);
            this.count = 0;
            this.position += (long)(len + 4);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.uncompressBytes += (long)len;
        while (len > 0) {
            if (this.count >= this.page.length) {
                this.flushBuffer();
            }
            int toWrite = Math.min(len, this.page.length - this.count);
            System.arraycopy(b, off, this.page, this.count, toWrite);
            off += toWrite;
            len -= toWrite;
            this.count += toWrite;
        }
    }

    @Override
    public void close() throws IOException {
        try (FileOutputStream ignored = this.out;){
            this.flushBuffer();
        }
    }

    public long uncompressBytes() {
        return this.uncompressBytes;
    }

    public long[] pages() {
        long[] pages = new long[this.pages.size()];
        for (int i = 0; i < pages.length; ++i) {
            pages[i] = this.pages.get(i);
        }
        return pages;
    }
}

