/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.time.ZoneId;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.hive.objectinspector.WriteableObjectInspector;

public class PaimonTimestampLocalTZObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements TimestampLocalTZObjectInspector,
WriteableObjectInspector {
    public PaimonTimestampLocalTZObjectInspector() {
        super((PrimitiveTypeInfo)TypeInfoFactory.timestampLocalTZTypeInfo);
    }

    public TimestampTZ getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        return new TimestampTZ(((Timestamp)o).toLocalDateTime().atZone(ZoneId.systemDefault()));
    }

    public TimestampLocalTZWritable getPrimitiveWritableObject(Object o) {
        TimestampTZ timestampTZ = this.getPrimitiveJavaObject(o);
        return timestampTZ == null ? null : new TimestampLocalTZWritable(timestampTZ);
    }

    public Object copyObject(Object o) {
        if (o instanceof Timestamp) {
            return o;
        }
        if (o instanceof TimestampTZ) {
            return new TimestampTZ(((TimestampTZ)o).getZonedDateTime());
        }
        return o;
    }

    @Override
    public Timestamp convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof TimestampTZ) {
            return Timestamp.fromLocalDateTime(((TimestampTZ)value).getZonedDateTime().toLocalDateTime());
        }
        return null;
    }
}

