/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.hive.objectinspector.PaimonCharObjectInspector;
import org.apache.paimon.hive.objectinspector.PaimonDateObjectInspector;
import org.apache.paimon.hive.objectinspector.PaimonDecimalObjectInspector;
import org.apache.paimon.hive.objectinspector.PaimonInternalRowObjectInspector;
import org.apache.paimon.hive.objectinspector.PaimonListObjectInspector;
import org.apache.paimon.hive.objectinspector.PaimonMapObjectInspector;
import org.apache.paimon.hive.objectinspector.PaimonStringObjectInspector;
import org.apache.paimon.hive.objectinspector.PaimonTimeObjectInspector;
import org.apache.paimon.hive.objectinspector.PaimonTimestampLocalTZObjectInspector;
import org.apache.paimon.hive.objectinspector.PaimonTimestampObjectInspector;
import org.apache.paimon.hive.objectinspector.PaimonVarcharObjectInspector;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.Preconditions;

public class PaimonObjectInspectorFactory {
    public static ObjectInspector create(DataType logicalType) {
        switch (logicalType.getTypeRoot()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case BINARY: 
            case VARBINARY: {
                return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)HiveTypeUtils.toTypeInfo(logicalType)));
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)logicalType;
                return new PaimonDecimalObjectInspector(decimalType.getPrecision(), decimalType.getScale());
            }
            case CHAR: {
                CharType charType = (CharType)logicalType;
                return new PaimonCharObjectInspector(charType.getLength());
            }
            case VARCHAR: {
                VarCharType varCharType = (VarCharType)logicalType;
                if (varCharType.getLength() == Integer.MAX_VALUE) {
                    return new PaimonStringObjectInspector();
                }
                return new PaimonVarcharObjectInspector(varCharType.getLength());
            }
            case DATE: {
                return new PaimonDateObjectInspector();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                TimeType timeType = (TimeType)logicalType;
                Preconditions.checkArgument(timeType.getPrecision() <= 3, "TIME type precision must be <= 3.");
                return new PaimonTimeObjectInspector();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return new PaimonTimestampObjectInspector();
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new PaimonTimestampLocalTZObjectInspector();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)logicalType;
                return new PaimonListObjectInspector(arrayType.getElementType());
            }
            case MAP: {
                MapType mapType = (MapType)logicalType;
                return new PaimonMapObjectInspector(mapType.getKeyType(), mapType.getValueType());
            }
            case ROW: {
                List<String> fieldComments = ((RowType)logicalType).getFields().stream().map(DataField::description).collect(Collectors.toList());
                List<DataType> fieldTypes = ((RowType)logicalType).getFieldTypes();
                List<String> fieldNames = ((RowType)logicalType).getFieldNames();
                return new PaimonInternalRowObjectInspector(fieldNames, fieldTypes, fieldComments);
            }
        }
        throw new UnsupportedOperationException("Unsupported logical type " + logicalType.asSQLString());
    }
}

